/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata2.model.curves.Curve;
import net.finmath.marketdata2.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.model.curves.ForwardCurveInterface;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.marketdata2.products.SwapAnnuity;
import net.finmath.marketdata2.products.SwapLeg;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.RegularSchedule;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;

public class Swap
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final AnalyticProduct legReceiver;
    private final AnalyticProduct legPayer;

    public Swap(AnalyticProduct legReceiver, AnalyticProduct legPayer) {
        this.legReceiver = legReceiver;
        this.legPayer = legPayer;
    }

    public Swap(Schedule scheduleReceiveLeg, String forwardCurveReceiveName, double spreadReceive, String discountCurveReceiveName, Schedule schedulePayLeg, String forwardCurvePayName, double spreadPay, String discountCurvePayName, boolean isNotionalExchanged) {
        this.legReceiver = new SwapLeg(scheduleReceiveLeg, forwardCurveReceiveName, spreadReceive, discountCurveReceiveName, isNotionalExchanged);
        this.legPayer = new SwapLeg(schedulePayLeg, forwardCurvePayName, spreadPay, discountCurvePayName, isNotionalExchanged);
    }

    public Swap(Schedule scheduleReceiveLeg, String forwardCurveReceiveName, double spreadReceive, String discountCurveReceiveName, Schedule schedulePayLeg, String forwardCurvePayName, double spreadPay, String discountCurvePayName) {
        this(scheduleReceiveLeg, forwardCurveReceiveName, spreadReceive, discountCurveReceiveName, schedulePayLeg, forwardCurvePayName, spreadPay, discountCurvePayName, true);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AnalyticModel model) {
        RandomVariable valueReceiverLeg = this.legReceiver.getValue(evaluationTime, model);
        RandomVariable valuePayerLeg = this.legPayer.getValue(evaluationTime, model);
        return valueReceiverLeg.sub(valuePayerLeg);
    }

    public static RandomVariable getForwardSwapRate(TimeDiscretization fixTenor, TimeDiscretization floatTenor, ForwardCurveInterface forwardCurve) {
        return Swap.getForwardSwapRate(new RegularSchedule(fixTenor), new RegularSchedule(floatTenor), forwardCurve);
    }

    public static RandomVariable getForwardSwapRate(TimeDiscretization fixTenor, TimeDiscretization floatTenor, ForwardCurveInterface forwardCurve, DiscountCurveInterface discountCurve) {
        AnalyticModelFromCurvesAndVols model = null;
        if (discountCurve != null) {
            model = new AnalyticModelFromCurvesAndVols(new Curve[]{forwardCurve, discountCurve});
        }
        return Swap.getForwardSwapRate(new RegularSchedule(fixTenor), new RegularSchedule(floatTenor), forwardCurve, model);
    }

    public static RandomVariable getForwardSwapRate(Schedule fixSchedule, Schedule floatSchedule, ForwardCurveInterface forwardCurve) {
        return Swap.getForwardSwapRate(fixSchedule, floatSchedule, forwardCurve, null);
    }

    public static RandomVariable getForwardSwapRate(Schedule fixSchedule, Schedule floatSchedule, ForwardCurveInterface forwardCurve, AnalyticModel model) {
        DiscountCurveInterface discountCurve;
        DiscountCurveInterface discountCurveInterface = discountCurve = model == null ? null : model.getDiscountCurve(forwardCurve.getDiscountCurveName());
        if (discountCurve == null) {
            discountCurve = new DiscountCurveFromForwardCurve(forwardCurve.getName());
            model = new AnalyticModelFromCurvesAndVols(new Curve[]{forwardCurve, discountCurve});
        }
        double evaluationTime = fixSchedule.getFixing(0);
        RandomVariable swapAnnuity = SwapAnnuity.getSwapAnnuity(evaluationTime, fixSchedule, discountCurve, model);
        double fixing = floatSchedule.getFixing(0);
        double payment = floatSchedule.getPayment(0);
        double periodLength = floatSchedule.getPeriodLength(0);
        RandomVariable forward = forwardCurve.getForward(model, fixing);
        RandomVariable discountFactor = discountCurve.getDiscountFactor(model, payment);
        RandomVariable floatLeg = forward.mult(discountFactor).mult(periodLength);
        for (int periodIndex = 1; periodIndex < floatSchedule.getNumberOfPeriods(); ++periodIndex) {
            fixing = floatSchedule.getFixing(periodIndex);
            payment = floatSchedule.getPayment(periodIndex);
            periodLength = floatSchedule.getPeriodLength(periodIndex);
            forward = forwardCurve.getForward(model, fixing);
            discountFactor = discountCurve.getDiscountFactor(model, payment);
            floatLeg = floatLeg.add(forward.mult(discountFactor).mult(periodLength));
        }
        RandomVariable valueFloatLeg = floatLeg.div(discountCurve.getDiscountFactor(model, evaluationTime));
        return valueFloatLeg.div(swapAnnuity);
    }

    public AnalyticProduct getLegReceiver() {
        return this.legReceiver;
    }

    public AnalyticProduct getLegPayer() {
        return this.legPayer;
    }

    public String toString() {
        return "Swap [legReceiver=" + this.legReceiver + ", legPayer=" + this.legPayer + "]";
    }
}

