/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor;

import java.time.LocalDate;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.modelling.descriptor.AssetModelDescriptor;

public class MertonModelDescriptor
implements AssetModelDescriptor {
    private final LocalDate referenceDate;
    private final Double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final Double volatility;
    private final Double jumpIntensity;
    private final Double jumpSizeMean;
    private final Double jumpSizeStdDev;

    public MertonModelDescriptor(LocalDate referenceDate, Double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, Double volatility, Double jumpIntensity, Double jumpSizeMean, Double jumpSizeStdDev) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.volatility = volatility;
        this.jumpIntensity = jumpIntensity;
        this.jumpSizeMean = jumpSizeMean;
        this.jumpSizeStdDev = jumpSizeStdDev;
    }

    @Override
    public Integer version() {
        return 1;
    }

    @Override
    public String name() {
        return "Single asset Merton Jump Diffusion model";
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public Double getInitialValue() {
        return this.initialValue;
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public Double getVolatility() {
        return this.volatility;
    }

    public Double getJumpIntensity() {
        return this.jumpIntensity;
    }

    public Double getJumpSizeMean() {
        return this.jumpSizeMean;
    }

    public Double getJumpSizeStdDev() {
        return this.jumpSizeStdDev;
    }
}

