/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor.xmlparser;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;
import net.finmath.modelling.descriptor.ScheduleDescriptor;
import net.finmath.modelling.descriptor.xmlparser.XMLParser;
import net.finmath.time.Period;
import net.finmath.time.daycount.DayCountConvention;
import net.finmath.time.daycount.DayCountConventionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FIPXMLParser
implements XMLParser {
    private final boolean agentIsBuyer;
    private final String discountCurveName;

    public FIPXMLParser() {
        this(false, null);
    }

    public FIPXMLParser(boolean agentIsBuyer, String discountCurveName) {
        this.agentIsBuyer = agentIsBuyer;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public ProductDescriptor getProductDescriptor(File file) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        doc.getDocumentElement().normalize();
        if (!doc.getDocumentElement().getNodeName().equalsIgnoreCase("FIPXML")) {
            throw new IllegalArgumentException("This parser is meant for XML of type FIPXML, but file was " + doc.getDocumentElement().getNodeName() + ".");
        }
        if (doc.getElementsByTagName("instrumentName").item(0).getTextContent().equalsIgnoreCase("Interest Rate Swap")) {
            return this.getSwapProductDescriptor(file);
        }
        throw new IllegalArgumentException("This xml parser is not set up to process trade of type " + doc.getElementsByTagName("instrumentName").item(0).getTextContent());
    }

    public InterestRateSwapProductDescriptor getSwapProductDescriptor(File file) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        doc.getDocumentElement().normalize();
        if (!doc.getDocumentElement().getNodeName().equalsIgnoreCase("FIPXML")) {
            throw new IllegalArgumentException("This parser is meant for XML of type FIPXML, but file was " + doc.getDocumentElement().getNodeName() + ".");
        }
        if (doc.getElementsByTagName("instrumentName").item(0).getTextContent().equalsIgnoreCase("Interest Rate Swap")) {
            if (doc.getElementsByTagName("legAgreement").getLength() != 2) {
                throw new IllegalArgumentException("Unknown swap configuration. Number of swap legs was " + doc.getElementsByTagName("legAgreement").getLength());
            }
        } else {
            throw new IllegalArgumentException("This xml parser is not set up to process trade of type " + doc.getElementsByTagName("instrumentName").item(0).getTextContent());
        }
        DayCountConvention daycountConvention = DayCountConventionFactory.getDayCountConvention(doc.getElementsByTagName("dayCountFraction").item(0).getTextContent());
        String forwardCurveName = null;
        NodeList temp = doc.getElementsByTagName("instrumentId");
        for (int index = 0; index < temp.getLength(); ++index) {
            Node id = temp.item(index);
            if (!id.getAttributes().getNamedItem("instrumentIdScheme").getTextContent().equalsIgnoreCase("INTERESTRATE")) continue;
            forwardCurveName = id.getTextContent();
            break;
        }
        String[] split = forwardCurveName.split("_");
        String discountCurveName = this.discountCurveName == null || this.discountCurveName.length() == 0 ? split[0] + "_" + split[1] : this.discountCurveName;
        InterestRateSwapLegProductDescriptor legReceiver = null;
        InterestRateSwapLegProductDescriptor legPayer = null;
        NodeList legs = doc.getElementsByTagName("legAgreement");
        for (int legIndex = 0; legIndex < legs.getLength(); ++legIndex) {
            Element leg = (Element)legs.item(legIndex);
            boolean isPayer = leg.getElementsByTagName("payDirection").item(0).getTextContent().equalsIgnoreCase("SELLER_TO_BUYER") && !this.agentIsBuyer || leg.getElementsByTagName("payDirection").item(0).getTextContent().equalsIgnoreCase("BUYER_TO_SELLER") && this.agentIsBuyer;
            boolean isFixed = leg.getElementsByTagName("interestType").item(0).getTextContent().equals("FIX");
            if (isPayer) {
                legPayer = FIPXMLParser.getSwapLegProductDescriptor(leg, isFixed ? null : forwardCurveName, discountCurveName, daycountConvention);
                continue;
            }
            legReceiver = FIPXMLParser.getSwapLegProductDescriptor(leg, isFixed ? null : forwardCurveName, discountCurveName, daycountConvention);
        }
        return new InterestRateSwapProductDescriptor(legReceiver, legPayer);
    }

    private static InterestRateSwapLegProductDescriptor getSwapLegProductDescriptor(Element leg, String forwardCurveName, String discountCurveName, DayCountConvention daycountConvention) {
        boolean isFixed = leg.getElementsByTagName("interestType").item(0).getTextContent().equalsIgnoreCase("FIX");
        ArrayList<Period> periods = new ArrayList<Period>();
        ArrayList<Double> notionalsList = new ArrayList<Double>();
        ArrayList<Double> rates = new ArrayList<Double>();
        NodeList periodsXML = leg.getElementsByTagName("incomePayment");
        for (int periodIndex = 0; periodIndex < periodsXML.getLength(); ++periodIndex) {
            Element periodXML = (Element)periodsXML.item(periodIndex);
            LocalDate startDate = LocalDate.parse(periodXML.getElementsByTagName("startDate").item(0).getTextContent());
            LocalDate endDate = LocalDate.parse(periodXML.getElementsByTagName("endDate").item(0).getTextContent());
            LocalDate fixingDate = startDate;
            LocalDate paymentDate = LocalDate.parse(periodXML.getElementsByTagName("payDate").item(0).getTextContent());
            if (!isFixed) {
                fixingDate = LocalDate.parse(periodXML.getElementsByTagName("fixingDate").item(0).getTextContent());
            }
            periods.add(new Period(fixingDate, paymentDate, startDate, endDate));
            double notional = Double.parseDouble(periodXML.getElementsByTagName("nominal").item(0).getTextContent());
            notionalsList.add(new Double(notional));
            if (isFixed) {
                double fixedRate = Double.parseDouble(periodXML.getElementsByTagName("fixedRate").item(0).getTextContent());
                rates.add(new Double(fixedRate));
                continue;
            }
            rates.add(new Double(0.0));
        }
        ScheduleDescriptor schedule = new ScheduleDescriptor(periods, daycountConvention);
        double[] notionals = notionalsList.stream().mapToDouble(Double::doubleValue).toArray();
        double[] spreads = rates.stream().mapToDouble(Double::doubleValue).toArray();
        return new InterestRateSwapLegProductDescriptor(forwardCurveName, discountCurveName, schedule, notionals, spreads, false);
    }
}

