/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.modelfactory;

import java.time.LocalDate;
import java.util.Map;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.modelling.DescribedModel;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ModelFactory;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.AnalyticModelDescriptor;
import net.finmath.modelling.productfactory.InterestRateAnalyticProductFactory;

public class AnalyticModelFactory
implements ModelFactory<AnalyticModelDescriptor> {
    @Override
    public DescribedModel<AnalyticModelDescriptor> getModelFromDescriptor(AnalyticModelDescriptor descriptor) {
        return new DescribedAnalyticModel(descriptor.getReferenceDate(), descriptor.getCurvesMap(), descriptor.getVolatilitySurfaceMap());
    }

    public static class DescribedAnalyticModel
    extends AnalyticModelFromCurvesAndVols
    implements DescribedModel<AnalyticModelDescriptor> {
        private static final long serialVersionUID = -2884913997994052340L;

        public DescribedAnalyticModel(LocalDate referenceDate, Map<String, Curve> curvesMap, Map<String, VolatilitySurface> volatilitySurfaceMap) {
            super(referenceDate, curvesMap, volatilitySurfaceMap);
        }

        @Override
        public AnalyticModelDescriptor getDescriptor() {
            return new AnalyticModelDescriptor(this.getReferenceDate(), this.getCurves(), this.getVolatilitySurfaces());
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return new InterestRateAnalyticProductFactory(this.getReferenceDate()).getProductFromDescriptor(productDescriptor);
        }
    }
}

