/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.modelfactory;

import net.finmath.fouriermethod.models.BlackScholesModel;
import net.finmath.fouriermethod.models.HestonModel;
import net.finmath.fouriermethod.models.MertonModel;
import net.finmath.fouriermethod.models.VarianceGammaModel;
import net.finmath.modelling.DescribedModel;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ModelFactory;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.AssetModelDescriptor;
import net.finmath.modelling.descriptor.BlackScholesModelDescriptor;
import net.finmath.modelling.descriptor.HestonModelDescriptor;
import net.finmath.modelling.descriptor.MertonModelDescriptor;
import net.finmath.modelling.descriptor.VarianceGammaModelDescriptor;
import net.finmath.modelling.productfactory.SingleAssetFourierProductFactory;

public class AssetModelFourierMethodFactory
implements ModelFactory<AssetModelDescriptor> {
    @Override
    public DescribedModel<? extends AssetModelDescriptor> getModelFromDescriptor(AssetModelDescriptor descriptor) {
        if (descriptor instanceof BlackScholesModelDescriptor) {
            BlackScholesModelFourier model = new BlackScholesModelFourier((BlackScholesModelDescriptor)descriptor);
            return model;
        }
        if (descriptor instanceof HestonModelDescriptor) {
            HestonModelFourier model = new HestonModelFourier((HestonModelDescriptor)descriptor);
            return model;
        }
        if (descriptor instanceof MertonModelDescriptor) {
            MertonModelFourier model = new MertonModelFourier((MertonModelDescriptor)descriptor);
            return model;
        }
        if (descriptor instanceof VarianceGammaModelDescriptor) {
            VarianceGammaModelFourier model = new VarianceGammaModelFourier((VarianceGammaModelDescriptor)descriptor);
            return model;
        }
        String name = descriptor.name();
        throw new IllegalArgumentException("Unsupported product type " + name);
    }

    private static class BlackScholesModelFourier
    extends BlackScholesModel
    implements DescribedModel<BlackScholesModelDescriptor> {
        private final BlackScholesModelDescriptor descriptor;
        private final SingleAssetFourierProductFactory productFactory;

        private BlackScholesModelFourier(BlackScholesModelDescriptor descriptor) {
            super(null, descriptor.getInitialValue(), descriptor.getDiscountCurveForForwardRate(), descriptor.getDiscountCurveForDiscountRate(), descriptor.getVolatility());
            this.descriptor = descriptor;
            this.productFactory = new SingleAssetFourierProductFactory(descriptor.getReferenceDate());
        }

        @Override
        public BlackScholesModelDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return this.productFactory.getProductFromDescriptor(productDescriptor);
        }
    }

    private static class HestonModelFourier
    extends HestonModel
    implements DescribedModel<HestonModelDescriptor> {
        private final HestonModelDescriptor descriptor;
        private final SingleAssetFourierProductFactory productFactory;

        private HestonModelFourier(HestonModelDescriptor descriptor) {
            super((double)descriptor.getInitialValue(), descriptor.getDiscountCurveForForwardRate(), descriptor.getDiscountCurveForDiscountRate(), (double)descriptor.getVolatility(), (double)descriptor.getTheta(), (double)descriptor.getKappa(), (double)descriptor.getXi(), (double)descriptor.getRho());
            this.descriptor = descriptor;
            this.productFactory = new SingleAssetFourierProductFactory(descriptor.getReferenceDate());
        }

        @Override
        public HestonModelDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return this.productFactory.getProductFromDescriptor(productDescriptor);
        }
    }

    private static class MertonModelFourier
    extends MertonModel
    implements DescribedModel<MertonModelDescriptor> {
        private final MertonModelDescriptor descriptor;
        private final SingleAssetFourierProductFactory productFactory;

        private MertonModelFourier(MertonModelDescriptor descriptor) {
            super(null, descriptor.getInitialValue(), descriptor.getDiscountCurveForForwardRate(), descriptor.getDiscountCurveForDiscountRate(), descriptor.getVolatility(), descriptor.getJumpIntensity(), descriptor.getJumpSizeMean(), descriptor.getJumpSizeStdDev());
            this.descriptor = descriptor;
            this.productFactory = new SingleAssetFourierProductFactory(descriptor.getReferenceDate());
        }

        @Override
        public MertonModelDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return this.productFactory.getProductFromDescriptor(productDescriptor);
        }
    }

    private static class VarianceGammaModelFourier
    extends VarianceGammaModel
    implements DescribedModel<VarianceGammaModelDescriptor> {
        private final VarianceGammaModelDescriptor descriptor;
        private final SingleAssetFourierProductFactory productFactory;

        private VarianceGammaModelFourier(VarianceGammaModelDescriptor descriptor) {
            super(null, descriptor.getInitialValue(), descriptor.getDiscountCurveForForwardRate(), descriptor.getDiscountCurveForDiscountRate(), descriptor.getSigma(), descriptor.getTheta(), descriptor.getNu());
            this.descriptor = descriptor;
            this.productFactory = new SingleAssetFourierProductFactory(descriptor.getReferenceDate());
        }

        @Override
        public VarianceGammaModelDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return this.productFactory.getProductFromDescriptor(productDescriptor);
        }
    }
}

