/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.productfactory;

import java.time.LocalDate;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.ProductFactory;
import net.finmath.modelling.SingleAssetProductDescriptor;
import net.finmath.modelling.descriptor.SingleAssetDigitalOptionProductDescriptor;
import net.finmath.modelling.descriptor.SingleAssetEuropeanOptionProductDescriptor;
import net.finmath.montecarlo.assetderivativevaluation.products.DigitalOption;
import net.finmath.montecarlo.assetderivativevaluation.products.EuropeanOption;
import net.finmath.time.FloatingpointDate;

public class SingleAssetMonteCarloProductFactory
implements ProductFactory<SingleAssetProductDescriptor> {
    private final LocalDate referenceDate;

    public SingleAssetMonteCarloProductFactory(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    @Override
    public DescribedProduct<? extends SingleAssetProductDescriptor> getProductFromDescriptor(ProductDescriptor descriptor) {
        if (descriptor instanceof SingleAssetEuropeanOptionProductDescriptor) {
            EuropeanOptionMonteCarlo product = new EuropeanOptionMonteCarlo((SingleAssetEuropeanOptionProductDescriptor)descriptor, this.referenceDate);
            return product;
        }
        if (descriptor instanceof SingleAssetDigitalOptionProductDescriptor) {
            DigitalOptionMonteCarlo product = new DigitalOptionMonteCarlo((SingleAssetDigitalOptionProductDescriptor)descriptor, this.referenceDate);
            return product;
        }
        String name = descriptor.name();
        throw new IllegalArgumentException("Unsupported product type " + name);
    }

    public static class EuropeanOptionMonteCarlo
    extends EuropeanOption
    implements DescribedProduct<SingleAssetEuropeanOptionProductDescriptor> {
        private final SingleAssetEuropeanOptionProductDescriptor descriptor;

        public EuropeanOptionMonteCarlo(SingleAssetEuropeanOptionProductDescriptor descriptor, LocalDate referenceDate) {
            super(descriptor.getUnderlyingName(), FloatingpointDate.getFloatingPointDateFromDate(referenceDate, descriptor.getMaturity()), descriptor.getStrike());
            this.descriptor = descriptor;
        }

        @Override
        public SingleAssetEuropeanOptionProductDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    public static class DigitalOptionMonteCarlo
    extends DigitalOption
    implements DescribedProduct<SingleAssetDigitalOptionProductDescriptor> {
        private final SingleAssetDigitalOptionProductDescriptor descriptor;

        public DigitalOptionMonteCarlo(SingleAssetDigitalOptionProductDescriptor descriptor, LocalDate referenceDate) {
            super(descriptor.getNameOfUnderlying(), FloatingpointDate.getFloatingPointDateFromDate(referenceDate, descriptor.getMaturity()), descriptor.getStrike());
            this.descriptor = descriptor;
        }

        @Override
        public SingleAssetDigitalOptionProductDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

