/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.Serializable;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.stochastic.RandomVariable;

public abstract class AbstractRandomVariableFactory
implements Serializable,
RandomVariableFactory {
    private static final long serialVersionUID = -4412332958142580025L;

    @Override
    public RandomVariable createRandomVariable(double value) {
        return this.createRandomVariable(Double.NEGATIVE_INFINITY, value);
    }

    @Override
    public abstract RandomVariable createRandomVariable(double var1, double var3);

    @Override
    public abstract RandomVariable createRandomVariable(double var1, double[] var3);

    @Override
    public RandomVariable[] createRandomVariableArray(double[] values) {
        RandomVariable[] valuesAsRandomVariables = new RandomVariable[values.length];
        for (int i = 0; i < values.length; ++i) {
            valuesAsRandomVariables[i] = this.createRandomVariable(Double.NEGATIVE_INFINITY, values[i]);
        }
        return valuesAsRandomVariables;
    }

    @Override
    public RandomVariable[][] createRandomVariableMatrix(double[][] values) {
        RandomVariable[][] valuesAsRandomVariables = new RandomVariable[values.length][];
        for (int i = 0; i < values.length; ++i) {
            valuesAsRandomVariables[i] = new RandomVariable[values[i].length];
            for (int j = 0; j < values[i].length; ++j) {
                valuesAsRandomVariables[i][j] = this.createRandomVariable(Double.NEGATIVE_INFINITY, values[i][j]);
            }
        }
        return valuesAsRandomVariables;
    }
}

