/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class BrownianBridge
implements BrownianMotion {
    private final BrownianMotion generator;
    private final RandomVariable[] start;
    private final RandomVariable[] end;
    private final RandomVariableFactory randomVariableFactory = new RandomVariableFromArrayFactory();
    private transient RandomVariable[][] brownianIncrements;
    private transient Object brownianIncrementsLazyInitLock = new Object();

    public BrownianBridge(BrownianMotion generator, RandomVariable[] start, RandomVariable[] end) {
        this.generator = generator;
        this.start = start;
        this.end = end;
    }

    public BrownianBridge(TimeDiscretization timeDiscretization, int numberOfPaths, int seed, RandomVariable[] start, RandomVariable[] end) {
        this(new BrownianMotionFromMersenneRandomNumbers(timeDiscretization, start.length, numberOfPaths, seed), start, end);
    }

    public BrownianBridge(TimeDiscretization timeDiscretization, int numberOfPaths, int seed, RandomVariable start, RandomVariable end) {
        this(timeDiscretization, numberOfPaths, seed, new RandomVariable[]{start}, new RandomVariable[]{end});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getBrownianIncrement(int timeIndex, int factor) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return this.brownianIncrements[timeIndex][factor];
    }

    private void doGenerateBrownianMotion() {
        if (this.brownianIncrements != null) {
            return;
        }
        this.brownianIncrements = new RandomVariable[this.generator.getTimeDiscretization().getNumberOfTimeSteps()][this.generator.getNumberOfFactors()];
        double endTime = this.getTimeDiscretization().getTime(this.getTimeDiscretization().getNumberOfTimeSteps());
        for (int factor = 0; factor < this.start.length; ++factor) {
            RandomVariable endOfFactor = this.end[factor];
            RandomVariable brownianBridge = this.start[factor];
            for (int timeIndex = 0; timeIndex < this.getTimeDiscretization().getNumberOfTimeSteps(); ++timeIndex) {
                double currentTime = this.getTimeDiscretization().getTime(timeIndex);
                double nextTime = this.getTimeDiscretization().getTime(timeIndex + 1);
                double alpha = (nextTime - currentTime) / (endTime - currentTime);
                RandomVariable nextRealization = brownianBridge.mult(1.0 - alpha).add(endOfFactor.mult(alpha)).add(this.generator.getBrownianIncrement(timeIndex, factor).mult(Math.sqrt(1.0 - alpha)));
                this.brownianIncrements[timeIndex][factor] = nextRealization.sub(brownianBridge);
                brownianBridge = nextRealization;
            }
        }
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.generator.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.generator.getNumberOfFactors();
    }

    @Override
    public int getNumberOfPaths() {
        return this.generator.getNumberOfPaths();
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public BrownianMotion getCloneWithModifiedSeed(int seed) {
        return new BrownianBridge(this.getTimeDiscretization(), this.getNumberOfPaths(), seed, this.start, this.end);
    }

    @Override
    public BrownianMotion getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new BrownianBridge(this.generator.getCloneWithModifiedTimeDiscretization(newTimeDiscretization), this.start, this.end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable[] getIncrement(int timeIndex) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return (RandomVariable[])this.brownianIncrements[timeIndex].clone();
    }

    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }

    public String toString() {
        return "BrownianBridge [generator=" + this.generator + Arrays.toString(this.start) + ", end=" + Arrays.toString(this.end) + "]";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.brownianIncrementsLazyInitLock = new Object();
    }
}

