/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.Serializable;
import net.finmath.functions.GammaDistribution;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.randomnumbers.MersenneTwister;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class GammaProcess
implements IndependentIncrements,
Serializable {
    private static final long serialVersionUID = -5430067621669213475L;
    private final double shape;
    private final double scale;
    private final TimeDiscretization timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private final RandomVariableFactory randomVariableFactory = new RandomVariableFromArrayFactory();
    private transient RandomVariable[][] gammaIncrements;

    public GammaProcess(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed, double shape, double scale) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.seed = seed;
        this.shape = shape;
        this.scale = scale;
        this.gammaIncrements = null;
    }

    public GammaProcess(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed, double shape) {
        this(timeDiscretization, numberOfFactors, numberOfPaths, seed, shape, 1.0);
    }

    @Override
    public IndependentIncrements getCloneWithModifiedSeed(int seed) {
        return new GammaProcess(this.getTimeDiscretization(), this.getNumberOfFactors(), this.getNumberOfPaths(), seed, this.shape);
    }

    @Override
    public IndependentIncrements getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new GammaProcess(newTimeDiscretization, this.getNumberOfFactors(), this.getNumberOfPaths(), this.getSeed(), this.shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        GammaProcess gammaProcess = this;
        synchronized (gammaProcess) {
            if (this.gammaIncrements == null) {
                this.doGenerateGammaIncrements();
            }
        }
        return this.gammaIncrements[timeIndex][factor];
    }

    private void doGenerateGammaIncrements() {
        int factor;
        int timeIndex;
        if (this.gammaIncrements != null) {
            return;
        }
        MersenneTwister mersenneTwister = new MersenneTwister(this.seed);
        double[][][] gammaIncrementsArray = new double[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors][this.numberOfPaths];
        GammaDistribution[] gammaDistributions = new GammaDistribution[this.timeDiscretization.getNumberOfTimeSteps()];
        for (timeIndex = 0; timeIndex < gammaDistributions.length; ++timeIndex) {
            double deltaT = this.timeDiscretization.getTimeStep(timeIndex);
            gammaDistributions[timeIndex] = new GammaDistribution(this.shape * deltaT, this.scale);
        }
        for (int path = 0; path < this.numberOfPaths; ++path) {
            for (int timeIndex2 = 0; timeIndex2 < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex2) {
                GammaDistribution gammaDistribution = gammaDistributions[timeIndex2];
                for (factor = 0; factor < this.numberOfFactors; ++factor) {
                    double uniformIncrement = mersenneTwister.nextDouble();
                    gammaIncrementsArray[timeIndex2][factor][path] = gammaDistribution.inverseCumulativeDistribution(uniformIncrement);
                }
            }
        }
        this.gammaIncrements = new RandomVariable[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double time = this.timeDiscretization.getTime(timeIndex + 1);
            for (factor = 0; factor < this.numberOfFactors; ++factor) {
                this.gammaIncrements[timeIndex][factor] = this.randomVariableFactory.createRandomVariable(time, gammaIncrementsArray[timeIndex][factor]);
            }
        }
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    public int getSeed() {
        return this.seed;
    }

    public String toString() {
        return super.toString() + "\ntimeDiscretizationFromArray: " + this.timeDiscretization.toString() + "\nnumberOfPaths: " + this.numberOfPaths + "\nnumberOfFactors: " + this.numberOfFactors + "\nseed: " + this.seed + "\nshape: " + this.shape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GammaProcess that = (GammaProcess)o;
        if (this.numberOfFactors != that.numberOfFactors) {
            return false;
        }
        if (this.numberOfPaths != that.numberOfPaths) {
            return false;
        }
        if (this.seed != that.seed) {
            return false;
        }
        return this.timeDiscretization.equals(that.timeDiscretization);
    }

    public int hashCode() {
        int result = this.timeDiscretization.hashCode();
        result = 31 * result + this.numberOfFactors;
        result = 31 * result + this.numberOfPaths;
        result = 31 * result + this.seed;
        result = 31 * result + Double.hashCode(this.shape);
        return result;
    }
}

