/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public interface IndependentIncrements {
    default public RandomVariable[] getIncrement(int timeIndex) {
        RandomVariable[] increment = new RandomVariable[this.getNumberOfFactors()];
        for (int factorIndex = 0; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
            increment[factorIndex] = this.getIncrement(timeIndex, factorIndex);
        }
        return increment;
    }

    public RandomVariable getIncrement(int var1, int var2);

    public TimeDiscretization getTimeDiscretization();

    public int getNumberOfFactors();

    public int getNumberOfPaths();

    public RandomVariable getRandomVariableForConstant(double var1);

    public IndependentIncrements getCloneWithModifiedSeed(int var1);

    public IndependentIncrements getCloneWithModifiedTimeDiscretization(TimeDiscretization var1);
}

