/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MonteCarloAssetModel
implements AssetModelMonteCarloSimulationModel {
    private final ProcessModel model;
    private final MonteCarloProcess process;

    public MonteCarloAssetModel(MonteCarloProcess process) {
        this.model = process.getModel();
        this.process = process;
    }

    public MonteCarloAssetModel(ProcessModel model, IndependentIncrements stochasticDriver) {
        this(new EulerSchemeFromProcessModel(model, stochasticDriver));
    }

    @Deprecated
    public MonteCarloAssetModel(ProcessModel model, MonteCarloProcess process) {
        this.model = model;
        this.process = process;
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            throw new IllegalArgumentException("The model does not provide an interpolation of simulation time (time given was " + time + ").");
        }
        return this.getAssetValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.process.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) throws CalculationException {
        double time = this.getTime(timeIndex);
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public MonteCarloAssetModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        MonteCarloProcess newProcess;
        ProcessModel newModel = this.model.getCloneWithModifiedData(dataModified);
        try {
            HashMap<String, Object> dataModifiedForProcess = new HashMap<String, Object>();
            dataModifiedForProcess.putAll(dataModified);
            if (!dataModifiedForProcess.containsKey("model")) {
                dataModifiedForProcess.put("model", newModel);
            }
            newProcess = this.process.getCloneWithModifiedData(dataModifiedForProcess);
        }
        catch (UnsupportedOperationException e) {
            newProcess = this.process;
        }
        if (newModel != this.model && newProcess == this.process) {
            newProcess = this.process.getCloneWithModifiedModel(newModel);
        }
        return new MonteCarloAssetModel(newProcess);
    }

    @Override
    @Deprecated
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedSeed(int seed) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public int getNumberOfPaths() {
        return this.process.getNumberOfPaths();
    }

    @Override
    public LocalDateTime getReferenceDate() {
        return this.model.getReferenceDate();
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }

    public ProcessModel getModel() {
        return this.model;
    }

    public MonteCarloProcess getProcess() {
        return this.process;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [model=" + this.model + "]";
    }
}

