/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.assetderivativevaluation.models.BlackScholesModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MonteCarloBlackScholesModel
extends MonteCarloAssetModel {
    private static final int seed = 3141;

    public MonteCarloBlackScholesModel(double initialValue, double riskFreeRate, double volatility, BrownianMotion brownianMotion) {
        super((ProcessModel)new BlackScholesModel(initialValue, riskFreeRate, volatility), brownianMotion);
    }

    public MonteCarloBlackScholesModel(TimeDiscretization timeDiscretization, int numberOfPaths, double initialValue, double riskFreeRate, double volatility) {
        this(initialValue, riskFreeRate, volatility, new BrownianMotionFromMersenneRandomNumbers(timeDiscretization, 1, numberOfPaths, 3141));
    }

    private MonteCarloBlackScholesModel(BlackScholesModel model, MonteCarloProcess process) {
        super((ProcessModel)model, process);
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            throw new IllegalArgumentException("The model does not provide an interpolation of simulation time (time given was " + time + ").");
        }
        return this.getAssetValue(timeIndex, assetIndex);
    }

    @Override
    public MonteCarloBlackScholesModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        MonteCarloProcess process = this.getProcess();
        ProcessModel newModel = this.getModel().getCloneWithModifiedData((Map)dataModified);
        int newSeed = dataModified.get("seed") != null ? ((Number)dataModified.get("seed")).intValue() : 3141;
        BrownianMotion newBrownianMotion = dataModified.get("seed") != null ? new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), newSeed) : (BrownianMotion)process.getStochasticDriver();
        double newInitialTime = dataModified.get("initialTime") != null ? ((Number)dataModified.get("initialTime")).doubleValue() : this.getTime(0);
        double timeShift = newInitialTime - this.getTime(0);
        if (timeShift != 0.0) {
            TimeDiscretization newTimeDiscretization = process.getStochasticDriver().getTimeDiscretization().getTimeShiftedTimeDiscretization(timeShift);
            newBrownianMotion = newBrownianMotion.getCloneWithModifiedTimeDiscretization(newTimeDiscretization);
        }
        EulerSchemeFromProcessModel newProcess = new EulerSchemeFromProcessModel(newModel, new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), 3141));
        return new MonteCarloBlackScholesModel((BlackScholesModel)newModel, (MonteCarloProcess)newProcess);
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedSeed(int seed) {
        EulerSchemeFromProcessModel process = new EulerSchemeFromProcessModel(this.getModel(), new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), seed));
        return new MonteCarloBlackScholesModel(this.getModel(), (MonteCarloProcess)process);
    }

    @Override
    public BlackScholesModel getModel() {
        return (BlackScholesModel)super.getModel();
    }
}

