/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.MertonJumpProcess;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.models.MertonModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MonteCarloMertonModel
implements AssetModelMonteCarloSimulationModel {
    private final MertonModel model;
    private final MonteCarloProcess process;
    private final double initialValue;
    private final int seed;

    public MonteCarloMertonModel(TimeDiscretization timeDiscretization, int numberOfPaths, int seed, double initialValue, double riskFreeRate, double volatility, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev, RandomVariableFactory randomVariableFactory) {
        this.initialValue = initialValue;
        this.seed = seed;
        double discountRate = riskFreeRate;
        this.model = new MertonModel(initialValue, riskFreeRate, volatility, discountRate, jumpIntensity, jumpSizeMean, jumpSizeStDev, randomVariableFactory);
        MertonJumpProcess icrements = new MertonJumpProcess(jumpIntensity, jumpSizeMean, jumpSizeStDev, timeDiscretization, numberOfPaths, seed);
        this.process = new EulerSchemeFromProcessModel(this.model, icrements, EulerSchemeFromProcessModel.Scheme.EULER_FUNCTIONAL);
    }

    public MonteCarloMertonModel(TimeDiscretization timeDiscretization, int numberOfPaths, int seed, double initialValue, double riskFreeRate, double volatility, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev) {
        this.initialValue = initialValue;
        this.seed = seed;
        this.model = new MertonModel(initialValue, riskFreeRate, volatility, jumpIntensity, jumpSizeMean, jumpSizeStDev);
        MertonJumpProcess icrements = new MertonJumpProcess(jumpIntensity, jumpSizeMean, jumpSizeStDev, timeDiscretization, numberOfPaths, seed);
        this.process = new EulerSchemeFromProcessModel(this.model, icrements, EulerSchemeFromProcessModel.Scheme.EULER_FUNCTIONAL);
    }

    @Override
    public LocalDateTime getReferenceDate() {
        throw new UnsupportedOperationException("This model does not provide a reference date. Reference dates will be mandatory in a future version.");
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            throw new IllegalArgumentException("The model does not provide an interpolation of simulation time (time given was " + time + ").");
        }
        return this.getAssetValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.process.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) throws CalculationException {
        double time = this.getTime(timeIndex);
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialTime = dataModified.get("initialTime") != null ? ((Number)dataModified.get("initialTime")).doubleValue() : this.getTime(0);
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue;
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.model.getRiskFreeRate().doubleValue().doubleValue();
        double newVolatility = dataModified.get("volatility") != null ? ((Number)dataModified.get("volatility")).doubleValue() : this.model.getVolatility().doubleValue().doubleValue();
        double newJumpIntensity = dataModified.get("jumpIntensity") != null ? ((Number)dataModified.get("jumpIntensity")).doubleValue() : this.model.getJumpIntensity().doubleValue().doubleValue();
        double newJumpSizeMean = dataModified.get("jumpSizeMean") != null ? ((Number)dataModified.get("jumpSizeMean")).doubleValue() : this.model.getVolatility().doubleValue().doubleValue();
        double newJumpSizeStdDev = dataModified.get("jumpSizeStdDev") != null ? ((Number)dataModified.get("jumpSizeStdDev")).doubleValue() : this.model.getVolatility().doubleValue().doubleValue();
        int newSeed = dataModified.get("seed") != null ? ((Number)dataModified.get("seed")).intValue() : this.seed;
        return new MonteCarloMertonModel(this.process.getTimeDiscretization().getTimeShiftedTimeDiscretization(newInitialTime - this.getTime(0)), this.process.getNumberOfPaths(), newSeed, newInitialValue, newRiskFreeRate, newVolatility, newJumpIntensity, newJumpSizeMean, newJumpSizeStdDev);
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedSeed(int seed) {
        HashMap<String, Integer> dataModified = new HashMap<String, Integer>();
        dataModified.put("seed", new Integer(seed));
        return this.getCloneWithModifiedData(dataModified);
    }

    @Override
    public int getNumberOfPaths() {
        return this.process.getNumberOfPaths();
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }
}

