/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.models;

import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class BachelierModel
extends AbstractProcessModel {
    private final RandomVariableFactory randomVariableFactory;
    private final RandomVariable initialValue;
    private final RandomVariable riskFreeRate;
    private final RandomVariable volatility;

    public BachelierModel(RandomVariableFactory randomVariableFactory, RandomVariable initialValue, RandomVariable riskFreeRate, RandomVariable volatility) {
        this.randomVariableFactory = randomVariableFactory;
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
    }

    public BachelierModel(double initialValue, double riskFreeRate, double volatility) {
        this.randomVariableFactory = new RandomVariableFromArrayFactory();
        this.initialValue = this.randomVariableFactory.createRandomVariable(initialValue);
        this.riskFreeRate = this.randomVariableFactory.createRandomVariable(riskFreeRate);
        this.volatility = this.randomVariableFactory.createRandomVariable(volatility);
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return new RandomVariable[]{this.initialValue};
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        RandomVariable[] drift = new RandomVariable[realizationAtTimeIndex.length];
        for (int componentIndex = 0; componentIndex < realizationAtTimeIndex.length; ++componentIndex) {
            drift[componentIndex] = new Scalar(0.0);
        }
        return drift;
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        return new RandomVariable[]{this.volatility};
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        double time = process.getTime(timeIndex);
        return randomVariable.mult(this.riskFreeRate.mult(time).exp());
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        double time = process.getTime(timeIndex);
        return randomVariable.div(this.riskFreeRate.mult(time).exp());
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        return this.riskFreeRate.mult(time).exp();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public int getNumberOfFactors() {
        return 1;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public BachelierModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory newRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", this.randomVariableFactory);
        RandomVariable newInitialValue = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("initialValue"), this.initialValue);
        RandomVariable newRiskFreeRate = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("riskFreeRate"), this.riskFreeRate);
        RandomVariable newVolatility = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("volatility"), this.volatility);
        return new BachelierModel(newRandomVariableFactory, newInitialValue, newRiskFreeRate, newVolatility);
    }

    public String toString() {
        return super.toString() + "\nBachelierModel:\n  initial value...:" + this.initialValue + "\n  risk free rate..:" + this.riskFreeRate + "\n  volatiliy.......:" + this.volatility;
    }

    public RandomVariable getInitialValue() {
        return this.initialValue;
    }

    public RandomVariable getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public RandomVariable getVolatility() {
        return this.volatility;
    }

    public RandomVariable getImpliedBachelierVolatility(double maturity) {
        return this.volatility.mult(this.riskFreeRate.mult(maturity).exp());
    }
}

