/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.models;

import java.util.Arrays;
import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;

public class BlackScholesModel
extends AbstractProcessModel {
    private final RandomVariableFactory randomVariableFactory;
    private final RandomVariable initialValue;
    private final RandomVariable riskFreeRate;
    private final RandomVariable volatility;
    private final RandomVariable[] initialState;
    private final RandomVariable[] drift;
    private final RandomVariable[] factorLoadings;

    public BlackScholesModel(RandomVariable initialValue, RandomVariable riskFreeRate, RandomVariable volatility, RandomVariableFactory randomVariableFactory) {
        this.initialValue = initialValue;
        this.volatility = volatility;
        this.riskFreeRate = riskFreeRate;
        this.randomVariableFactory = randomVariableFactory;
        this.initialState = new RandomVariable[]{initialValue.log()};
        this.drift = new RandomVariable[]{riskFreeRate.sub(volatility.squared().div(2.0))};
        this.factorLoadings = new RandomVariable[]{volatility};
    }

    public BlackScholesModel(double initialValue, double riskFreeRate, double volatility, RandomVariableFactory randomVariableFactory) {
        this(randomVariableFactory.createRandomVariable(initialValue), randomVariableFactory.createRandomVariable(riskFreeRate), randomVariableFactory.createRandomVariable(volatility), randomVariableFactory);
    }

    public BlackScholesModel(double initialValue, double riskFreeRate, double volatility) {
        this(initialValue, riskFreeRate, volatility, (RandomVariableFactory)new RandomVariableFromArrayFactory());
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return this.initialState;
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        return this.drift;
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        return this.factorLoadings;
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        return this.riskFreeRate.mult(time).exp();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public int getNumberOfFactors() {
        return 1;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public BlackScholesModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        double newInitialValue = dataModified.get("initialValue") != null ? ((Number)dataModified.get("initialValue")).doubleValue() : this.initialValue.getAverage();
        double newRiskFreeRate = dataModified.get("riskFreeRate") != null ? ((Number)dataModified.get("riskFreeRate")).doubleValue() : this.getRiskFreeRate().getAverage();
        double newVolatility = dataModified.get("volatility") != null ? ((Number)dataModified.get("volatility")).doubleValue() : this.getVolatility().getAverage();
        return new BlackScholesModel(newInitialValue, newRiskFreeRate, newVolatility, this.randomVariableFactory);
    }

    @Override
    public RandomVariable[] getInitialValue(MonteCarloProcess process) {
        return new RandomVariable[]{this.initialValue};
    }

    public RandomVariable getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public RandomVariable getVolatility() {
        return this.factorLoadings[0];
    }

    public String toString() {
        return "BlackScholesModel [initialValue=" + this.initialValue + ", riskFreeRate=" + this.riskFreeRate + ", volatility=" + this.volatility + ", randomVariableFactory=" + this.randomVariableFactory + ", initialState=" + Arrays.toString(this.initialState) + ", drift=" + Arrays.toString(this.drift) + ", factorLoadings=" + Arrays.toString(this.factorLoadings) + "]";
    }
}

