/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.models;

import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;

public class InhomogeneousDisplacedLognomalModel
extends AbstractProcessModel {
    private final RandomVariableFactory randomVariableFactory;
    private final RandomVariable initialValue;
    private final RandomVariable riskFreeRate;
    private final RandomVariable displacement;
    private final RandomVariable volatility;
    private final boolean isUseMilsteinCorrection;

    public InhomogeneousDisplacedLognomalModel(RandomVariableFactory randomVariableFactory, RandomVariable initialValue, RandomVariable riskFreeRate, RandomVariable displacement, RandomVariable volatility, boolean isUseMilsteinCorrection) {
        this.randomVariableFactory = randomVariableFactory;
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.displacement = displacement;
        this.volatility = volatility;
        this.isUseMilsteinCorrection = isUseMilsteinCorrection;
    }

    public InhomogeneousDisplacedLognomalModel(RandomVariableFactory randomVariableFactory, double initialValue, double riskFreeRate, double displacement, double volatility, boolean isUseMilsteinCorrection) {
        this(randomVariableFactory, randomVariableFactory.createRandomVariable(initialValue), randomVariableFactory.createRandomVariable(riskFreeRate), randomVariableFactory.createRandomVariable(displacement), randomVariableFactory.createRandomVariable(volatility), isUseMilsteinCorrection);
    }

    public InhomogeneousDisplacedLognomalModel(double initialValue, double riskFreeRate, double displacement, double volatility, boolean isUseMilsteinCorrection) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), initialValue, riskFreeRate, displacement, volatility, isUseMilsteinCorrection);
    }

    public InhomogeneousDisplacedLognomalModel(double initialValue, double riskFreeRate, double displacement, double volatility) {
        this(initialValue, riskFreeRate, displacement, volatility, false);
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return new RandomVariable[]{this.initialValue.add(this.displacement)};
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        double time = process.getTimeDiscretization().getTime(timeIndex);
        double timeNext = process.getTimeDiscretization().getTime(timeIndex + 1);
        double dt = timeNext - time;
        RandomVariable[] drift = new RandomVariable[realizationAtTimeIndex.length];
        for (int componentIndex = 0; componentIndex < realizationAtTimeIndex.length; ++componentIndex) {
            drift[componentIndex] = this.displacement.mult(this.riskFreeRate.mult(-timeNext).exp().sub(this.riskFreeRate.mult(-time).exp()).div(timeNext - time));
            if (!this.isUseMilsteinCorrection) continue;
            drift[componentIndex] = drift[componentIndex].add(this.getFactorLoading(process, timeIndex, componentIndex, realizationAtTimeIndex)[0].mult(this.volatility).div(2.0).mult(process.getStochasticDriver().getIncrement(timeIndex, 0).squared().sub(dt)));
        }
        return drift;
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] volatilityOnPaths = new RandomVariable[realizationAtTimeIndex.length];
        for (int componentIndex = 0; componentIndex < realizationAtTimeIndex.length; ++componentIndex) {
            volatilityOnPaths[componentIndex] = this.applyStateSpaceTransformInverse(process, timeIndex, componentIndex, realizationAtTimeIndex[componentIndex]).mult(this.volatility);
        }
        return volatilityOnPaths;
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.mult(this.riskFreeRate.mult(process.getTime(timeIndex)).exp()).sub(this.displacement);
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.add(this.displacement).div(this.riskFreeRate.mult(process.getTime(timeIndex)).exp());
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        return this.riskFreeRate.mult(time).exp();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public int getNumberOfFactors() {
        return 1;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public InhomogeneousDisplacedLognomalModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory newRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", this.randomVariableFactory);
        RandomVariable newInitialValue = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("initialValue"), this.initialValue);
        RandomVariable newRiskFreeRate = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("riskFreeRate"), this.riskFreeRate);
        RandomVariable newDisplacement = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("displacement"), this.displacement);
        RandomVariable newVolatility = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("volatility"), this.volatility);
        return new InhomogeneousDisplacedLognomalModel(newRandomVariableFactory, newInitialValue, newRiskFreeRate, newDisplacement, newVolatility, this.isUseMilsteinCorrection);
    }

    public String toString() {
        return "InhomogeneousDisplacedLognomalModel [randomVariableFactory=" + this.randomVariableFactory + ", initialValue=" + this.initialValue + ", riskFreeRate=" + this.riskFreeRate + ", displacement=" + this.displacement + ", volatility=" + this.volatility + ", isUseMilsteinCorrection=" + this.isUseMilsteinCorrection + "]";
    }

    public RandomVariableFactory getRandomVariableFactory() {
        return this.randomVariableFactory;
    }

    public RandomVariable getInitialValue() {
        return this.initialValue;
    }

    public RandomVariable getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public RandomVariable getDisplacement() {
        return this.displacement;
    }

    public RandomVariable getVolatility() {
        return this.volatility;
    }
}

