/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.models;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.modelling.descriptor.VarianceGammaModelDescriptor;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;

public class VarianceGammaModel
extends AbstractProcessModel {
    private final RandomVariableFactory randomVariableFactory;
    private final RandomVariable initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final RandomVariable riskFreeRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final RandomVariable discountRate;
    private final RandomVariable sigma;
    private final RandomVariable theta;
    private final RandomVariable nu;

    public VarianceGammaModel(RandomVariable initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, RandomVariable sigma, RandomVariable theta, RandomVariable nu, RandomVariableFactory randomVariableFactory) {
        this.randomVariableFactory = randomVariableFactory;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = null;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = null;
        this.sigma = sigma;
        this.theta = theta;
        this.nu = nu;
    }

    public VarianceGammaModel(RandomVariable initialValue, RandomVariable riskFreeRate, RandomVariable discountRate, RandomVariable sigma, RandomVariable theta, RandomVariable nu, RandomVariableFactory randomVariableFactory) {
        this.randomVariableFactory = new RandomVariableFromArrayFactory();
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = null;
        this.riskFreeRate = riskFreeRate;
        this.discountCurveForDiscountRate = null;
        this.discountRate = discountRate;
        this.sigma = sigma;
        this.theta = theta;
        this.nu = nu;
    }

    public VarianceGammaModel(VarianceGammaModelDescriptor descriptor) {
        this((double)descriptor.getInitialValue(), descriptor.getDiscountCurveForForwardRate(), descriptor.getDiscountCurveForDiscountRate(), descriptor.getSigma(), descriptor.getTheta(), descriptor.getNu());
    }

    public VarianceGammaModel(double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double sigma, double theta, double nu, RandomVariableFactory randomVariableFactory) {
        this.initialValue = randomVariableFactory.createRandomVariable(initialValue);
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = null;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = null;
        this.sigma = randomVariableFactory.createRandomVariable(sigma);
        this.theta = randomVariableFactory.createRandomVariable(theta);
        this.nu = randomVariableFactory.createRandomVariable(nu);
        this.randomVariableFactory = randomVariableFactory;
    }

    public VarianceGammaModel(double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double sigma, double theta, double nu) {
        this(initialValue, discountCurveForDiscountRate, discountCurveForDiscountRate, sigma, theta, nu, (RandomVariableFactory)new RandomVariableFromArrayFactory());
    }

    public VarianceGammaModel(double initialValue, double riskFreeRate, double discountRate, double sigma, double theta, double nu) {
        this.randomVariableFactory = new RandomVariableFromArrayFactory();
        this.initialValue = this.randomVariableFactory.createRandomVariable(initialValue);
        this.discountCurveForForwardRate = null;
        this.riskFreeRate = this.randomVariableFactory.createRandomVariable(riskFreeRate);
        this.discountCurveForDiscountRate = null;
        this.discountRate = this.randomVariableFactory.createRandomVariable(discountRate);
        this.sigma = this.randomVariableFactory.createRandomVariable(sigma);
        this.theta = this.randomVariableFactory.createRandomVariable(theta);
        this.nu = this.randomVariableFactory.createRandomVariable(nu);
    }

    public VarianceGammaModel(double initialValue, double riskFreeRate, double sigma, double theta, double nu) {
        this(initialValue, riskFreeRate, riskFreeRate, sigma, theta, nu);
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return new RandomVariable[]{this.initialValue.log()};
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        if (this.discountCurveForDiscountRate != null) {
            return this.getRandomVariableForConstant(1.0 / this.discountCurveForDiscountRate.getDiscountFactor(time));
        }
        return this.discountRate.mult(time).exp();
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        RandomVariable riskFreeRateAtTimeStep;
        if (this.discountCurveForForwardRate != null) {
            double time = process.getTime(timeIndex);
            double timeNext = process.getTime(timeIndex + 1);
            riskFreeRateAtTimeStep = this.getRandomVariableForConstant(Math.log(this.discountCurveForForwardRate.getDiscountFactor(time) / this.discountCurveForForwardRate.getDiscountFactor(timeNext)) / (timeNext - time));
        } else {
            riskFreeRateAtTimeStep = this.riskFreeRate;
        }
        return new RandomVariable[]{riskFreeRateAtTimeStep.add(this.theta.mult(this.nu).add(this.sigma.squared().mult(this.nu).mult(0.5)).mult(-1.0).add(1.0).log().div(this.nu))};
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factors = new RandomVariable[]{this.getRandomVariableForConstant(1.0)};
        return factors;
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public int getNumberOfFactors() {
        return 1;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public ProcessModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        RandomVariableFactory newRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", this.randomVariableFactory);
        RandomVariable newInitialValue = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("initialValue"), this.initialValue);
        RandomVariable newRiskFreeRate = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("riskFreeRate"), this.riskFreeRate);
        RandomVariable newDiscountRate = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("discountRate"), this.discountRate);
        RandomVariable newSigma = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("sigma"), this.sigma);
        RandomVariable newTheta = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("theta"), this.theta);
        RandomVariable newNu = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("nu"), this.nu);
        return new VarianceGammaModel(newInitialValue, newRiskFreeRate, newDiscountRate, newSigma, newTheta, newNu, newRandomVariableFactory);
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public RandomVariable getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public RandomVariable getDiscountRate() {
        return this.discountRate;
    }

    public RandomVariable getSigma() {
        return this.sigma;
    }

    public RandomVariable getTheta() {
        return this.theta;
    }

    public RandomVariable getNu() {
        return this.nu;
    }

    public String toString() {
        return "VarianceGammaModel [initialValue=" + this.initialValue + ", discountCurveForForwardRate=" + this.discountCurveForForwardRate + ", riskFreeRate=" + this.riskFreeRate + ", discountCurveForDiscountRate=" + this.discountCurveForDiscountRate + ", discountRate=" + this.discountRate + ", sigma=" + this.sigma + ", theta=" + this.theta + ", nu=" + this.nu + "]";
    }
}

