/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class BasketOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double[] weights;
    private final String[] nameOfUnderliyngs;

    public BasketOption(double maturity, double strike, double[] weights) {
        this.maturity = maturity;
        this.strike = strike;
        this.weights = weights;
        this.nameOfUnderliyngs = null;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = model.getRandomVariableForConstant(0.0);
        for (int underlyingIndex = 0; underlyingIndex < this.weights.length; ++underlyingIndex) {
            RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, underlyingIndex);
            values = values.addProduct(underlyingAtMaturity, this.weights[underlyingIndex]);
        }
        values = values.sub(this.strike).floor(0.0);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloWeightsAtEvalTime);
        return values;
    }
}

