/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import java.util.Arrays;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import org.apache.commons.lang3.Validate;

public class BermudanOption
extends AbstractAssetMonteCarloProduct {
    private final double[] exerciseDates;
    private final double[] notionals;
    private final double[] strikes;
    private final int numberOfBasisFunctions;
    private final boolean intrinsicValueAsBasisFunction;
    private final boolean useBinning;
    private final ExerciseMethod exerciseMethod;
    private RandomVariable lastValuationExerciseTime;
    private RandomVariable[] lastValuationExerciseValueAtExerciseTime;
    private RandomVariable[] lastValuationContinuationValueAtExerciseTime;
    private RandomVariable[] lastValuationContinuationValueEstimatedAtExerciseTime;

    public BermudanOption(double[] exerciseDates, double[] notionals, double[] strikes, ExerciseMethod exerciseMethod, int numberOfBasisFunctions, boolean intrinsicValueAsBasisFunction, boolean useBinning) {
        Validate.isTrue((numberOfBasisFunctions > 0 ? 1 : 0) != 0, (String)"The vaue of numberOfBasisFunctions must be larger or equal 1. %s", (long)numberOfBasisFunctions);
        this.exerciseDates = exerciseDates;
        this.notionals = notionals;
        this.strikes = strikes;
        this.exerciseMethod = exerciseMethod;
        this.numberOfBasisFunctions = numberOfBasisFunctions;
        this.intrinsicValueAsBasisFunction = intrinsicValueAsBasisFunction;
        this.useBinning = useBinning;
    }

    public BermudanOption(double[] exerciseDates, double[] notionals, double[] strikes, ExerciseMethod exerciseMethod) {
        this(exerciseDates, notionals, strikes, exerciseMethod, 5, false, false);
    }

    public BermudanOption(double[] exerciseDates, double[] notionals, double[] strikes) {
        this(exerciseDates, notionals, strikes, ExerciseMethod.ESTIMATE_COND_EXPECTATION);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        if (this.exerciseMethod == ExerciseMethod.UPPER_BOUND_METHOD) {
            GoldenSectionSearch optimizer = new GoldenSectionSearch(-1.0, 1.0);
            while (!optimizer.isDone()) {
                double lambda = optimizer.getNextPoint();
                double value = this.getValue(evaluationTime, model, lambda).getAverage();
                optimizer.setValue(value);
            }
            return this.getValue(evaluationTime, model, optimizer.getBestPoint());
        }
        return this.getValue(evaluationTime, model, 0.0);
    }

    private RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model, double lambda) throws CalculationException {
        RandomVariable value = model.getRandomVariableForConstant(0.0);
        RandomVariable exerciseTime = model.getRandomVariableForConstant(this.exerciseDates[this.exerciseDates.length - 1] + 1.0);
        this.lastValuationExerciseValueAtExerciseTime = new RandomVariable[this.exerciseDates.length];
        this.lastValuationContinuationValueAtExerciseTime = new RandomVariable[this.exerciseDates.length];
        this.lastValuationContinuationValueEstimatedAtExerciseTime = new RandomVariable[this.exerciseDates.length];
        for (int exerciseDateIndex = this.exerciseDates.length - 1; exerciseDateIndex >= 0; --exerciseDateIndex) {
            double exerciseDate = this.exerciseDates[exerciseDateIndex];
            double notional = this.notionals[exerciseDateIndex];
            double strike = this.strikes[exerciseDateIndex];
            RandomVariable underlyingAtExercise = model.getAssetValue(exerciseDate, 0);
            RandomVariable numeraireAtPayment = model.getNumeraire(exerciseDate);
            RandomVariable monteCarloWeights = model.getMonteCarloWeights(exerciseDate);
            RandomVariable valueOfPaymentsIfExercised = underlyingAtExercise.sub(strike).mult(notional).div(numeraireAtPayment).mult(monteCarloWeights);
            RandomVariable exerciseValue = null;
            RandomVariable exerciseCriteria = null;
            switch (this.exerciseMethod) {
                case ESTIMATE_COND_EXPECTATION: {
                    RandomVariable basisFunctionUnderlying = this.intrinsicValueAsBasisFunction ? underlyingAtExercise.sub(strike).floor(0.0) : underlyingAtExercise;
                    ArrayList<RandomVariable> basisFunctions = this.useBinning ? this.getRegressionBasisFunctionsBinning(basisFunctionUnderlying) : this.getRegressionBasisFunctions(basisFunctionUnderlying);
                    MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(basisFunctions.toArray(new RandomVariable[0]));
                    RandomVariable valueIfNotExcercisedEstimated = value.getConditionalExpectation(condExpEstimator);
                    exerciseValue = valueOfPaymentsIfExercised;
                    exerciseCriteria = valueIfNotExcercisedEstimated.sub(exerciseValue);
                    break;
                }
                case UPPER_BOUND_METHOD: {
                    RandomVariable martingale = model.getAssetValue(this.exerciseDates[exerciseDateIndex], 0).div(model.getNumeraire(this.exerciseDates[exerciseDateIndex]));
                    martingale = martingale.sub(martingale.getAverage()).mult(lambda);
                    if (exerciseDateIndex == this.exerciseDates.length - 1) {
                        value = value.sub(martingale);
                    }
                    exerciseValue = valueOfPaymentsIfExercised.sub(martingale);
                    exerciseCriteria = value.sub(exerciseValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown exerciseMethod " + this.exerciseMethod + ".");
                }
            }
            this.lastValuationExerciseValueAtExerciseTime[exerciseDateIndex] = exerciseValue.mult(model.getNumeraire(this.exerciseDates[exerciseDateIndex])).div(model.getMonteCarloWeights(this.exerciseDates[exerciseDateIndex]));
            this.lastValuationContinuationValueAtExerciseTime[exerciseDateIndex] = value.mult(model.getNumeraire(this.exerciseDates[exerciseDateIndex])).div(model.getMonteCarloWeights(this.exerciseDates[exerciseDateIndex]));
            this.lastValuationContinuationValueEstimatedAtExerciseTime[exerciseDateIndex] = exerciseCriteria.add(exerciseValue).mult(model.getNumeraire(this.exerciseDates[exerciseDateIndex])).div(model.getMonteCarloWeights(this.exerciseDates[exerciseDateIndex]));
            value = exerciseCriteria.choose(value, exerciseValue);
            exerciseTime = exerciseCriteria.choose(exerciseTime, Scalar.of(exerciseDate));
        }
        this.lastValuationExerciseTime = exerciseTime;
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        value = value.mult(numeraireAtEvalTime).div(monteCarloWeightsAtEvalTime);
        return value;
    }

    public double[] getExerciseDates() {
        return this.exerciseDates;
    }

    public double[] getNotionals() {
        return this.notionals;
    }

    public double[] getStrikes() {
        return this.strikes;
    }

    public RandomVariable getLastValuationExerciseTime() {
        return this.lastValuationExerciseTime;
    }

    public RandomVariable[] getLastValuationExerciseValueAtExerciseTime() {
        return this.lastValuationExerciseValueAtExerciseTime;
    }

    public RandomVariable[] getLastValuationContinuationValueAtExerciseTime() {
        return this.lastValuationContinuationValueAtExerciseTime;
    }

    public RandomVariable[] getLastValuationContinuationValueEstimatedAtExerciseTime() {
        return this.lastValuationContinuationValueEstimatedAtExerciseTime;
    }

    private ArrayList<RandomVariable> getRegressionBasisFunctions(RandomVariable underlying) {
        int orderOfRegressionPolynomial = this.numberOfBasisFunctions - 1;
        underlying = new RandomVariableFromDoubleArray(0.0, underlying.getRealizations());
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        for (int powerOfRegressionMonomial = 0; powerOfRegressionMonomial <= orderOfRegressionPolynomial; ++powerOfRegressionMonomial) {
            basisFunctions.add(underlying.pow(powerOfRegressionMonomial));
        }
        return basisFunctions;
    }

    private ArrayList<RandomVariable> getRegressionBasisFunctionsBinning(RandomVariable underlying) {
        int numberOfBins = this.numberOfBasisFunctions;
        underlying = new RandomVariableFromDoubleArray(0.0, underlying.getRealizations());
        double[] values = underlying.getRealizations();
        Arrays.sort(values);
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        for (int i = 0; i < numberOfBins; ++i) {
            double binLeft = values[(int)((double)i / (double)numberOfBins * (double)values.length)];
            RandomVariable basisFunction = underlying.sub(binLeft).choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0));
            basisFunctions.add(basisFunction);
        }
        return basisFunctions;
    }

    public static enum ExerciseMethod {
        ESTIMATE_COND_EXPECTATION,
        UPPER_BOUND_METHOD;

    }
}

