/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class BlackScholesHedgedPortfolio
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double riskFreeRate;
    private final double volatility;
    private final double hedgeOptionMaturity;
    private final double hedgeOptionStrike;
    private final HedgeStrategy hedgeStrategy;

    public BlackScholesHedgedPortfolio(double maturity, double strike, double riskFreeRate, double volatility, double hedgeOptionMaturity, double hedgeOptionStrike, HedgeStrategy hedgeStrategy) {
        this.maturity = maturity;
        this.strike = strike;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.hedgeOptionMaturity = hedgeOptionMaturity;
        this.hedgeOptionStrike = hedgeOptionStrike;
        this.hedgeStrategy = hedgeStrategy;
    }

    public BlackScholesHedgedPortfolio(double maturity, double strike, double riskFreeRate, double volatility) {
        this(maturity, strike, riskFreeRate, volatility, 0.0, 0.0, HedgeStrategy.deltaHedge);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable underlyingToday = model.getAssetValue(0.0, 0);
        RandomVariable numeraireToday = model.getNumeraire(0.0);
        RandomVariable valueOfOptionAccordingBlackScholes = AnalyticFormulas.blackScholesOptionValue(underlyingToday, this.riskFreeRate, this.volatility, this.maturity - 0.0, this.strike);
        RandomVariable amountOfNumeraireAsset = valueOfOptionAccordingBlackScholes.div(numeraireToday);
        RandomVariable amountOfUnderlyingAsset = model.getRandomVariableForConstant(0.0);
        RandomVariable amountOfHedgeOptions = model.getRandomVariableForConstant(0.0);
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        for (int timeIndex = 0; timeIndex < timeIndexEvaluationTime; ++timeIndex) {
            RandomVariable newNumberOfNumeraireAsset;
            RandomVariable newNumberOfHedgeOptions;
            RandomVariable underlyingAtTimeIndex = model.getAssetValue(timeIndex, 0);
            RandomVariable numeraireAtTimeIndex = model.getNumeraire(timeIndex);
            RandomVariable delta = AnalyticFormulas.blackScholesOptionDelta(underlyingAtTimeIndex, this.riskFreeRate, this.volatility, this.maturity - model.getTime(timeIndex), this.strike);
            RandomVariable gamma = model.getRandomVariableForConstant(0.0);
            if (this.hedgeOptionStrike != 0.0) {
                gamma = AnalyticFormulas.blackScholesOptionGamma(underlyingAtTimeIndex, this.riskFreeRate, this.volatility, this.maturity - model.getTime(timeIndex), this.strike);
            }
            RandomVariable vega = model.getRandomVariableForConstant(0.0);
            if (this.hedgeOptionStrike != 0.0) {
                vega = AnalyticFormulas.blackScholesOptionVega(underlyingAtTimeIndex, this.riskFreeRate, this.volatility, this.maturity - model.getTime(timeIndex), this.strike);
            }
            RandomVariable priceOfHedgeOption = AnalyticFormulas.blackScholesOptionValue(underlyingAtTimeIndex, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndex), this.hedgeOptionStrike);
            RandomVariable deltaOfHedgeOption = AnalyticFormulas.blackScholesOptionDelta(underlyingAtTimeIndex, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndex), this.hedgeOptionStrike);
            RandomVariable gammaOfHedgeOption = AnalyticFormulas.blackScholesOptionGamma(underlyingAtTimeIndex, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndex), this.hedgeOptionStrike);
            RandomVariable vegaOfHedgeOption = AnalyticFormulas.blackScholesOptionVega(underlyingAtTimeIndex, this.riskFreeRate, this.volatility, this.hedgeOptionMaturity - model.getTime(timeIndex), this.hedgeOptionStrike);
            switch (this.hedgeStrategy) {
                case deltaGammaHedge: {
                    newNumberOfHedgeOptions = gamma.div(gammaOfHedgeOption);
                    break;
                }
                case deltaVegaHedge: {
                    newNumberOfHedgeOptions = vega.div(vegaOfHedgeOption);
                    break;
                }
                default: {
                    newNumberOfHedgeOptions = new Scalar(0.0);
                }
            }
            RandomVariable hedgeOptionsToBuy = newNumberOfHedgeOptions.sub(amountOfHedgeOptions);
            RandomVariable newNumberOfStocks = delta = delta.sub(newNumberOfHedgeOptions.mult(deltaOfHedgeOption));
            RandomVariable stocksToBuy = newNumberOfStocks.sub(amountOfUnderlyingAsset);
            RandomVariable numeraireAssetsToSell = stocksToBuy.mult(underlyingAtTimeIndex).add(hedgeOptionsToBuy.mult(priceOfHedgeOption)).div(numeraireAtTimeIndex);
            amountOfNumeraireAsset = newNumberOfNumeraireAsset = amountOfNumeraireAsset.sub(numeraireAssetsToSell);
            amountOfUnderlyingAsset = newNumberOfStocks;
            amountOfHedgeOptions = newNumberOfHedgeOptions;
        }
        RandomVariable underlyingAtEvaluationTime = model.getAssetValue(evaluationTime, 0);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable priceOfHedgeOption = this.hedgeStrategy.equals((Object)HedgeStrategy.deltaHedge) ? new Scalar(0.0) : AnalyticFormulas.blackScholesOptionValue(underlyingAtEvaluationTime, model.getRandomVariableForConstant(this.riskFreeRate), model.getRandomVariableForConstant(this.volatility), this.hedgeOptionMaturity - model.getTime(timeIndexEvaluationTime), this.hedgeOptionStrike);
        RandomVariable portfolioValue = amountOfNumeraireAsset.mult(numeraireAtEvaluationTime).add(amountOfUnderlyingAsset.mult(underlyingAtEvaluationTime)).add(amountOfHedgeOptions.mult(priceOfHedgeOption));
        return portfolioValue;
    }

    public static enum HedgeStrategy {
        deltaHedge,
        deltaGammaHedge,
        deltaVegaHedge;

    }
}

