/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class DigitalOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final Integer underlyingIndex;
    private final String nameOfUnderlying;

    public DigitalOption(double maturity, double strike, int underlyingIndex) {
        this.maturity = maturity;
        this.strike = strike;
        this.underlyingIndex = underlyingIndex;
        this.nameOfUnderlying = null;
    }

    public DigitalOption(double maturity, double strike) {
        this(maturity, strike, 0);
    }

    public DigitalOption(String nameOfUnderlying, double maturity, double strike) {
        this.nameOfUnderlying = nameOfUnderlying;
        this.maturity = maturity;
        this.strike = strike;
        this.underlyingIndex = 0;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, (int)this.underlyingIndex);
        RandomVariable values = underlyingAtMaturity.sub(this.strike).choose(new Scalar(1.0), new Scalar(0.0));
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloWeightsAtEvalTime);
        return values;
    }

    public double getMaturity() {
        return this.maturity;
    }

    public double getStrike() {
        return this.strike;
    }

    public Integer getUnderlyingIndex() {
        return this.underlyingIndex;
    }

    public String getNameOfUnderlying() {
        return this.nameOfUnderlying;
    }

    @Override
    public String toString() {
        return "DigitalOption [maturity=" + this.maturity + ", strike=" + this.strike + ", underlyingIndex=" + this.underlyingIndex + ", nameOfUnderlying=" + this.nameOfUnderlying + "]";
    }
}

