/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.models.BlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class DigitalOptionDeltaLikelihood
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;

    public DigitalOptionDeltaLikelihood(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        BlackScholesModel blackScholesModel = null;
        if (model instanceof MonteCarloAssetModel) {
            try {
                blackScholesModel = (BlackScholesModel)((MonteCarloAssetModel)model).getModel();
            }
            catch (Exception exception) {}
        } else if (model instanceof MonteCarloBlackScholesModel) {
            blackScholesModel = ((MonteCarloBlackScholesModel)model).getModel();
        }
        if (model == null) {
            throw new ClassCastException("This method requires a Black-Scholes type model (MonteCarloBlackScholesModel).");
        }
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, 0);
        RandomVariable underlyingAtToday = model.getAssetValue(0.0, 0);
        double T = this.maturity - evaluationTime;
        double r = blackScholesModel.getRiskFreeRate().doubleValue();
        double sigma = blackScholesModel.getVolatility().doubleValue();
        RandomVariable lr = underlyingAtMaturity.log().sub(underlyingAtToday.log()).sub(r * T - 0.5 * sigma * sigma * T).div(sigma * sigma * T).div(underlyingAtToday);
        RandomVariable payoff = underlyingAtMaturity.sub(this.strike).choose(new Scalar(1.0), new Scalar(0.0));
        RandomVariable modifiedPayoff = payoff.mult(lr);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtMaturity = model.getMonteCarloWeights(this.maturity);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        return modifiedPayoff.div(numeraireAtMaturity).mult(numeraireAtEvalTime).mult(monteCarloWeightsAtMaturity).div(monteCarloWeightsAtEvalTime);
    }
}

