/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.modelling.Model;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class EuropeanOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double callOrPutSign;
    private final Integer underlyingIndex;
    private final String nameOfUnderliyng;

    public EuropeanOption(String underlyingName, double maturity, double strike, double callOrPutSign) {
        this.nameOfUnderliyng = underlyingName;
        this.maturity = maturity;
        this.strike = strike;
        this.callOrPutSign = callOrPutSign;
        this.underlyingIndex = 0;
    }

    public EuropeanOption(double maturity, double strike, double callOrPutSign, int underlyingIndex) {
        this.maturity = maturity;
        this.strike = strike;
        this.callOrPutSign = callOrPutSign;
        this.underlyingIndex = underlyingIndex;
        this.nameOfUnderliyng = null;
    }

    public EuropeanOption(String underlyingName, double maturity, double strike) {
        this(underlyingName, maturity, strike, 1.0);
    }

    public EuropeanOption(double maturity, double strike, int underlyingIndex) {
        this(maturity, strike, 1.0, underlyingIndex);
    }

    public EuropeanOption(double maturity, double strike) {
        this(maturity, strike, 0);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, (int)this.underlyingIndex);
        RandomVariable values = underlyingAtMaturity.sub(this.strike).mult(this.callOrPutSign).floor(0.0);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloWeightsAtEvalTime);
        return values;
    }

    @Override
    public Map<String, Object> getValues(double evaluationTime, Model model) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            double value = this.getValue(evaluationTime, (AssetModelMonteCarloSimulationModel)model).getAverage();
            result.put("value", value);
        }
        catch (CalculationException e) {
            result.put("exception", e);
        }
        return result;
    }

    @Override
    public String toString() {
        return "EuropeanOption [maturity=" + this.maturity + ", strike=" + this.strike + ", underlyingIndex=" + this.underlyingIndex + ", nameOfUnderliyng=" + this.nameOfUnderliyng + "]";
    }

    public double getMaturity() {
        return this.maturity;
    }

    public double getStrike() {
        return this.strike;
    }

    public Integer getUnderlyingIndex() {
        return this.underlyingIndex;
    }

    public String getNameOfUnderliyng() {
        return this.nameOfUnderliyng;
    }
}

