/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.models.BlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class EuropeanOptionDeltaPathwise
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;

    public EuropeanOptionDeltaPathwise(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        if (!MonteCarloBlackScholesModel.class.isInstance(model) && MonteCarloAssetModel.class.isInstance(model) && !BlackScholesModel.class.isInstance(((MonteCarloAssetModel)model).getModel())) {
            Logger.getLogger("net.finmath").warning("This method assumes a Black-Scholes type model (MonteCarloBlackScholesModel).");
        }
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, 0);
        RandomVariable underlyingAtEvalTime = model.getAssetValue(evaluationTime, 0);
        RandomVariable trigger = underlyingAtMaturity.sub(this.strike);
        RandomVariable values = trigger.choose(underlyingAtMaturity, new Scalar(0.0)).div(underlyingAtEvalTime);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloWeightsAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloWeightsAtEvalTime);
        return values;
    }
}

