/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.RandomVariableAccumulator;

public class EuropeanOptionGammaPathwise
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;

    public EuropeanOptionGammaPathwise(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
    }

    public double getValue(AssetModelMonteCarloSimulationModel model) throws CalculationException {
        MonteCarloBlackScholesModel blackScholesModel = null;
        try {
            blackScholesModel = (MonteCarloBlackScholesModel)model;
        }
        catch (Exception e) {
            throw new ClassCastException("This method requires a Black-Scholes type model (MonteCarloBlackScholesModel).");
        }
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable underlyingAtToday = model.getAssetValue(0.0, 0);
        RandomVariable numeraireAtToday = model.getNumeraire(0);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        double average = 0.0;
        for (int path = 0; path < model.getNumberOfPaths(); ++path) {
            double T = this.maturity;
            double S0 = underlyingAtToday.get(0);
            double r = blackScholesModel.getModel().getRiskFreeRate().doubleValue();
            double sigma = blackScholesModel.getModel().getVolatility().doubleValue();
            double x = 1.0 / (sigma * Math.sqrt(T)) * (Math.log(this.strike) - (r * T - 0.5 * sigma * sigma * T + Math.log(S0)));
            double jumpSize = this.strike / underlyingAtToday.get(path);
            double phiAtStrike = 1.0 / Math.sqrt(Math.PI * 2) * Math.exp(-x * x / 2.0) / (this.strike * sigma * Math.sqrt(T));
            average += jumpSize * phiAtStrike / numeraireAtMaturity.get(path) * monteCarloWeights.get(path) * numeraireAtToday.get(path);
        }
        return average;
    }

    @Override
    public RandomVariableAccumulator getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) {
        throw new RuntimeException("Method not supported.");
    }
}

