/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class FiniteDifferenceHedgedPortfolio
extends AbstractAssetMonteCarloProduct {
    private final AbstractAssetMonteCarloProduct productToHedge;
    private final AssetModelMonteCarloSimulationModel modelUsedForHedging;
    private final ArrayList<AbstractAssetMonteCarloProduct> hedgeProducts;
    private final HedgeStrategy hedgeStrategy;

    public FiniteDifferenceHedgedPortfolio(AbstractAssetMonteCarloProduct productToHedge, AssetModelMonteCarloSimulationModel modelUsedForHedging, ArrayList<AbstractAssetMonteCarloProduct> hedgeProducts, HedgeStrategy hedgeStrategy) {
        this.productToHedge = productToHedge;
        this.modelUsedForHedging = modelUsedForHedging;
        this.hedgeProducts = hedgeProducts;
        this.hedgeStrategy = hedgeStrategy;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        int numberOfPath = model.getNumberOfPaths();
        ArrayList amountOfHedgeAssets = new ArrayList(this.hedgeProducts.size());
        RandomVariable underlyingToday = model.getAssetValue(0.0, 0);
        double initialValue = underlyingToday.get(0);
        double valueOfOptionAccordingHedgeModel = this.productToHedge.getValue(this.modelUsedForHedging);
        return new RandomVariableFromDoubleArray(evaluationTime, 0.0);
    }

    public static enum HedgeStrategy {
        deltaHedge,
        deltaGammaHedge;

    }
}

