/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class LocalRiskMinimizingHedgePortfolio
extends AbstractAssetMonteCarloProduct {
    private final AbstractAssetMonteCarloProduct productToHedge;
    private final AssetModelMonteCarloSimulationModel modelUsedForHedging;
    private final TimeDiscretization timeDiscretizationForRebalancing;
    private final int numberOfBins;

    public LocalRiskMinimizingHedgePortfolio(AbstractAssetMonteCarloProduct productToHedge, AssetModelMonteCarloSimulationModel modelUsedForHedging, TimeDiscretization timeDiscretizationForRebalancing, int numberOfBins) {
        this.productToHedge = productToHedge;
        this.modelUsedForHedging = modelUsedForHedging;
        this.timeDiscretizationForRebalancing = timeDiscretizationForRebalancing;
        this.numberOfBins = numberOfBins;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        int numberOfPath = model.getNumberOfPaths();
        RandomVariable numeraireToday = model.getNumeraire(0.0);
        double valueOfOptionAccordingHedgeModel = this.productToHedge.getValue(this.modelUsedForHedging);
        RandomVariable amountOfNumeraireAsset = numeraireToday.invert().mult(valueOfOptionAccordingHedgeModel);
        RandomVariable amountOfUderlyingAsset = model.getRandomVariableForConstant(0.0);
        for (int timeIndex = 0; timeIndex < this.timeDiscretizationForRebalancing.getNumberOfTimes() - 1; ++timeIndex) {
            RandomVariable newNumberOfNumeraireAsset;
            double time = this.timeDiscretizationForRebalancing.getTime(timeIndex);
            double timeNext = this.timeDiscretizationForRebalancing.getTime(timeIndex + 1);
            if (time > evaluationTime) break;
            RandomVariable underlyingAtTime = this.modelUsedForHedging.getAssetValue(time, 0);
            RandomVariable numeraireAtTime = this.modelUsedForHedging.getNumeraire(time);
            RandomVariable underlyingAtTimeNext = this.modelUsedForHedging.getAssetValue(timeNext, 0);
            RandomVariable numeraireAtTimeNext = this.modelUsedForHedging.getNumeraire(timeNext);
            RandomVariable productAtTime = this.productToHedge.getValue(time, this.modelUsedForHedging);
            RandomVariable productAtTimeNext = this.productToHedge.getValue(timeNext, this.modelUsedForHedging);
            RandomVariable[] basisFunctionsEstimator = this.getBasisFunctions(this.modelUsedForHedging.getAssetValue(time, 0));
            RandomVariable[] basisFunctionsPredictor = this.getBasisFunctions(model.getAssetValue(time, 0));
            MonteCarloConditionalExpectationRegression condExpectationHedging = new MonteCarloConditionalExpectationRegression(basisFunctionsEstimator, basisFunctionsEstimator);
            MonteCarloConditionalExpectationRegression condExpectationValuation = new MonteCarloConditionalExpectationRegression(basisFunctionsEstimator, basisFunctionsPredictor);
            RandomVariable underlyingRebased = underlyingAtTimeNext.div(numeraireAtTimeNext);
            RandomVariable underlyingRebasedExpected = condExpectationHedging.getConditionalExpectation(underlyingRebased);
            RandomVariable underlyingRebasedMartingale = underlyingRebased.sub(underlyingRebasedExpected);
            RandomVariable derivativeRebased = productAtTimeNext.div(numeraireAtTimeNext);
            RandomVariable derivativeRebasedExpected = condExpectationHedging.getConditionalExpectation(derivativeRebased);
            RandomVariable derivativeRebasedMartingale = derivativeRebased.sub(derivativeRebasedExpected);
            RandomVariable derivativeTimesUnderlying = derivativeRebasedMartingale.mult(underlyingRebasedMartingale);
            RandomVariable derivativeTimesUnderlyingExpected = condExpectationValuation.getConditionalExpectation(derivativeTimesUnderlying);
            RandomVariable underlyingRabasedMartingaleSquared = underlyingRebasedMartingale.squared();
            RandomVariable underlyingRabasedMartingaleSquaredExpected = condExpectationValuation.getConditionalExpectation(underlyingRabasedMartingaleSquared);
            RandomVariable delta = derivativeTimesUnderlyingExpected.div(underlyingRabasedMartingaleSquaredExpected);
            RandomVariable underlyingValue = model.getAssetValue(time, 0);
            RandomVariable numeraireValue = model.getNumeraire(time);
            RandomVariable newNumberOfStocks = delta;
            RandomVariable stocksToBuy = newNumberOfStocks.sub(amountOfUderlyingAsset);
            RandomVariable numeraireAssetsToBuy = stocksToBuy.mult(underlyingValue).div(numeraireValue).mult(-1.0);
            amountOfNumeraireAsset = newNumberOfNumeraireAsset = amountOfNumeraireAsset.add(numeraireAssetsToBuy);
            amountOfUderlyingAsset = newNumberOfStocks;
        }
        RandomVariable underlyingAtEvaluationTime = model.getAssetValue(evaluationTime, 0);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable portfolioValue = amountOfNumeraireAsset.mult(numeraireAtEvaluationTime).add(amountOfUderlyingAsset.mult(underlyingAtEvaluationTime));
        return portfolioValue;
    }

    private RandomVariable[] getBasisFunctions(RandomVariable underlying) {
        double[] discretization;
        double min = underlying.getMin();
        double max = underlying.getMax();
        ArrayList<RandomVariable> basisFunctionList = new ArrayList<RandomVariable>();
        for (double discretizationStep : discretization = new TimeDiscretizationFromArray(min, this.numberOfBins, (max - min) / (double)this.numberOfBins).getAsDoubleArray()) {
            RandomVariable indicator = underlying.sub(discretizationStep).choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0));
            basisFunctionList.add(indicator);
        }
        return basisFunctionList.toArray(new RandomVariable[0]);
    }
}

