/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward;

import java.util.HashMap;
import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.automaticdifferentiation.AbstractRandomVariableDifferentiableFactory;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiable;
import net.finmath.montecarlo.automaticdifferentiation.backward.RandomVariableDifferentiableAAD;

public class RandomVariableDifferentiableAADFactory
extends AbstractRandomVariableDifferentiableFactory {
    private static final long serialVersionUID = -6035830497454502442L;
    private final DiracDeltaApproximationMethod diracDeltaApproximationMethod;
    private final double diracDeltaApproximationWidthPerStdDev;
    private final double diracDeltaApproximationDensityRegressionWidthPerStdDev;
    private final boolean isGradientRetainsLeafNodesOnly;

    public RandomVariableDifferentiableAADFactory(RandomVariableFactory randomVariableFactoryForNonDifferentiable, Map<String, Object> properties) {
        super(randomVariableFactoryForNonDifferentiable);
        this.diracDeltaApproximationMethod = DiracDeltaApproximationMethod.valueOf((String)properties.getOrDefault("diracDeltaApproximationMethod", DiracDeltaApproximationMethod.DISCRETE_DELTA.name()));
        this.diracDeltaApproximationWidthPerStdDev = (Double)properties.getOrDefault("diracDeltaApproximationWidthPerStdDev", properties.getOrDefault("barrierDiracWidth", 0.05));
        this.diracDeltaApproximationDensityRegressionWidthPerStdDev = (Double)properties.getOrDefault("diracDeltaApproximationDensityRegressionWidthPerStdDev", 0.5);
        this.isGradientRetainsLeafNodesOnly = (Boolean)properties.getOrDefault("isGradientRetainsLeafNodesOnly", true);
    }

    public RandomVariableDifferentiableAADFactory(Map<String, Object> properties) {
        this(new RandomVariableFromArrayFactory(), properties);
    }

    public RandomVariableDifferentiableAADFactory(RandomVariableFactory randomVariableFactoryForNonDifferentiable) {
        this(randomVariableFactoryForNonDifferentiable, new HashMap<String, Object>());
    }

    public RandomVariableDifferentiableAADFactory() {
        this(new RandomVariableFromArrayFactory());
    }

    @Override
    public RandomVariableDifferentiable createRandomVariable(double time, double value) {
        return new RandomVariableDifferentiableAAD(this.createRandomVariableNonDifferentiable(time, value), this);
    }

    @Override
    public RandomVariableDifferentiable createRandomVariable(double time, double[] values) {
        return new RandomVariableDifferentiableAAD(this.createRandomVariableNonDifferentiable(time, values), this);
    }

    public DiracDeltaApproximationMethod getDiracDeltaApproximationMethod() {
        return this.diracDeltaApproximationMethod;
    }

    public double getDiracDeltaApproximationWidthPerStdDev() {
        return this.diracDeltaApproximationWidthPerStdDev;
    }

    public double getDiracDeltaApproximationDensityRegressionWidthPerStdDev() {
        return this.diracDeltaApproximationDensityRegressionWidthPerStdDev;
    }

    @Deprecated
    public double getBarrierDiracWidth() {
        return this.getDiracDeltaApproximationWidthPerStdDev();
    }

    public boolean isGradientRetainsLeafNodesOnly() {
        return this.isGradientRetainsLeafNodesOnly;
    }

    @Override
    public String toString() {
        return "RandomVariableDifferentiableAADFactory [diracDeltaApproximationMethod=" + this.diracDeltaApproximationMethod + ", diracDeltaApproximationWidthPerStdDev=" + this.diracDeltaApproximationWidthPerStdDev + ", diracDeltaApproximationDensityRegressionWidthPerStdDev=" + this.diracDeltaApproximationDensityRegressionWidthPerStdDev + ", isGradientRetainsLeafNodesOnly=" + this.isGradientRetainsLeafNodesOnly + ", toString()=" + super.toString() + "]";
    }

    public static enum DiracDeltaApproximationMethod {
        DISCRETE_DELTA,
        REGRESSION_ON_DENSITY,
        REGRESSION_ON_DISTRIBUITON,
        ONE,
        ZERO;

    }
}

