/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.conditionalexpectation;

import net.finmath.functions.LinearAlgebra;
import net.finmath.stochastic.RandomVariable;

public class LinearRegression {
    private final RandomVariable[] basisFunctions;

    public LinearRegression(RandomVariable[] basisFunctions) {
        this.basisFunctions = basisFunctions;
    }

    public double[] getRegressionCoefficients(RandomVariable value) {
        double covariance;
        if (this.basisFunctions.length == 0) {
            return new double[0];
        }
        if (this.basisFunctions.length == 1) {
            return new double[]{value.mult(this.basisFunctions[0]).getAverage() / this.basisFunctions[0].squared().getAverage()};
        }
        if (this.basisFunctions.length == 2) {
            double b;
            double a = this.basisFunctions[0].squared().getAverage();
            double c = b = this.basisFunctions[0].mult(this.basisFunctions[1]).average().squared().doubleValue().doubleValue();
            double d = this.basisFunctions[1].squared().getAverage();
            double determinant = a * d - b * c;
            if (determinant != 0.0) {
                double x = value.mult(this.basisFunctions[0]).getAverage();
                double y = value.mult(this.basisFunctions[1]).getAverage();
                double alpha0 = (d * x - b * y) / determinant;
                double alpha1 = (a * y - c * x) / determinant;
                return new double[]{alpha0, alpha1};
            }
        }
        double[][] BTB = new double[this.basisFunctions.length][this.basisFunctions.length];
        for (int i = 0; i < this.basisFunctions.length; ++i) {
            for (int j = 0; j <= i; ++j) {
                BTB[i][j] = covariance = this.basisFunctions[i].mult(this.basisFunctions[j]).getAverage();
                BTB[j][i] = covariance;
            }
        }
        double[] BTX = new double[this.basisFunctions.length];
        for (int i = 0; i < this.basisFunctions.length; ++i) {
            BTX[i] = covariance = this.basisFunctions[i].mult(value).getAverage();
        }
        return LinearAlgebra.solveLinearEquationLeastSquare(BTB, BTX);
    }
}

