/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.conditionalexpectation;

import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class MonteCarloConditionalExpectationRegressionLocalizedOnDependents
extends MonteCarloConditionalExpectationRegression {
    private final double standardDeviations;

    public MonteCarloConditionalExpectationRegressionLocalizedOnDependents(RandomVariable[] basisFunctionsEstimator, RandomVariable[] basisFunctionsPredictor, double standardDeviations) {
        super(basisFunctionsEstimator, basisFunctionsPredictor);
        this.standardDeviations = standardDeviations;
    }

    public MonteCarloConditionalExpectationRegressionLocalizedOnDependents(RandomVariable[] basisFunctionsEstimator, double standardDeviations) {
        super(basisFunctionsEstimator);
        this.standardDeviations = standardDeviations;
    }

    public MonteCarloConditionalExpectationRegressionLocalizedOnDependents() {
        this(null, 4.0);
    }

    public MonteCarloConditionalExpectationRegressionLocalizedOnDependents(RandomVariable[] basisFunctions) {
        this(basisFunctions, 4.0);
    }

    public MonteCarloConditionalExpectationRegressionLocalizedOnDependents(RandomVariable[] basisFunctionsEstimator, RandomVariable[] basisFunctionsPredictor) {
        this(basisFunctionsEstimator, basisFunctionsPredictor, 4.0);
    }

    @Override
    public double[] getLinearRegressionParameters(RandomVariable dependents) {
        RandomVariable localizerWeights = dependents.squared().sub(Math.pow(dependents.getStandardDeviation() * this.standardDeviations, 2.0)).choose(new Scalar(0.0), new Scalar(1.0));
        RandomVariable[] basisFunctionsNonLocalized = this.getBasisFunctionsEstimator().getBasisFunctions();
        RandomVariable[] basisFunctions = new RandomVariable[basisFunctionsNonLocalized.length];
        for (int i = 0; i < basisFunctions.length; ++i) {
            basisFunctions[i] = basisFunctionsNonLocalized[i].mult(localizerWeights);
        }
        dependents = dependents.mult(localizerWeights);
        double[][] XTX = new double[basisFunctions.length][basisFunctions.length];
        for (int i = 0; i < basisFunctions.length; ++i) {
            for (int j = i; j < basisFunctions.length; ++j) {
                XTX[i][j] = basisFunctions[i].mult(basisFunctions[j]).getAverage();
                XTX[j][i] = XTX[i][j];
            }
        }
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(XTX, false)).getSolver();
        double[] XTy = new double[basisFunctions.length];
        for (int i = 0; i < basisFunctions.length; ++i) {
            XTy[i] = dependents.mult(basisFunctions[i]).getAverage();
        }
        double[] linearRegressionParameters = solver.solve((RealVector)new ArrayRealVector(XTy)).toArray();
        return linearRegressionParameters;
    }
}

