/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;

public class ConvexityAdjustedModel {
    private final ProcessModel baseModel;
    private final MonteCarloProcess measureTransformModel;
    private final Map<Integer, Integer> factorLoadingMap;

    public ConvexityAdjustedModel(ProcessModel baseModel, MonteCarloProcess measureTransformModel, Map<Integer, Integer> factorLoadingMap) {
        this.baseModel = baseModel;
        this.measureTransformModel = measureTransformModel;
        this.factorLoadingMap = factorLoadingMap;
    }

    public RandomVariable[] getDrift(RandomVariable[] driftUnadjusted, MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        RandomVariable[] driftAdjusted = new RandomVariable[this.baseModel.getNumberOfComponents()];
        RandomVariable[] processValueTransformModel = null;
        try {
            processValueTransformModel = this.measureTransformModel.getProcessValue(timeIndex);
            for (int componentIndex = 0; componentIndex < this.baseModel.getNumberOfComponents(); ++componentIndex) {
                if (driftUnadjusted[componentIndex] == null) continue;
                driftAdjusted[componentIndex] = driftUnadjusted[componentIndex];
                RandomVariable[] factorLoadingsBaseModel = this.baseModel.getFactorLoading(process, timeIndex, componentIndex, realizationAtTimeIndex);
                RandomVariable[] factorLoadingsTransfrom = this.measureTransformModel.getModel().getFactorLoading(this.measureTransformModel, timeIndex, 0, processValueTransformModel);
                for (int factorIndex = 0; factorIndex < factorLoadingsBaseModel.length; ++factorIndex) {
                    if (!this.factorLoadingMap.containsKey(factorIndex)) continue;
                    driftAdjusted[componentIndex] = driftAdjusted[componentIndex].addProduct(factorLoadingsBaseModel[factorIndex].mult(-1.0), factorLoadingsTransfrom[this.factorLoadingMap.get(factorIndex)]);
                }
                driftAdjusted[componentIndex] = driftAdjusted[componentIndex];
            }
        }
        catch (CalculationException calculationException) {
            // empty catch block
        }
        return driftAdjusted;
    }
}

