/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloMultiAssetBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.EuropeanOption;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulation;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulationFromModels;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.optimizer.SolverException;

public class ModelFactory {
    private static ModelFactory modelFactory;

    private ModelFactory() {
    }

    public static synchronized ModelFactory getInstance() {
        if (modelFactory == null) {
            modelFactory = new ModelFactory();
        }
        return modelFactory;
    }

    public HybridAssetLIBORModelMonteCarloSimulation getHybridAssetLIBORModel(final LIBORModelMonteCarloSimulationModel baseModel, final BrownianMotion brownianMotion, final double[] initialValues, final double riskFreeRate, final double[][] correlations, final double[] maturities, final double[] strikes, double[] volatilities, DiscountCurve discountCurve) throws CalculationException {
        LevenbergMarquardt optimizer = new LevenbergMarquardt(volatilities, volatilities, 100, 1){
            private static final long serialVersionUID = -9199565564991442848L;

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                MonteCarloMultiAssetBlackScholesModel model = new MonteCarloMultiAssetBlackScholesModel(brownianMotion, initialValues, riskFreeRate, parameters, correlations);
                HybridAssetLIBORModelMonteCarloSimulationFromModels hybridModel = new HybridAssetLIBORModelMonteCarloSimulationFromModels(baseModel, model);
                try {
                    for (int assetIndex = 0; assetIndex < values.length; ++assetIndex) {
                        double impliedVol;
                        double df = hybridModel.getNumeraire(maturities[assetIndex]).invert().getAverage();
                        double spot = hybridModel.getAssetValue(0.0, assetIndex).getAverage();
                        EuropeanOption option = new EuropeanOption(maturities[assetIndex], strikes[assetIndex], assetIndex);
                        double valueOptoin = option.getValue(hybridModel);
                        values[assetIndex] = impliedVol = AnalyticFormulas.blackScholesOptionImpliedVolatility(spot / df, maturities[assetIndex], strikes[assetIndex], df, valueOptoin);
                    }
                }
                catch (CalculationException e) {
                    throw new SolverException(e);
                }
            }
        };
        try {
            optimizer.run();
        }
        catch (SolverException e) {
            if (e.getCause() instanceof CalculationException) {
                throw (CalculationException)e.getCause();
            }
            throw new CalculationException(e);
        }
        MonteCarloMultiAssetBlackScholesModel model = new MonteCarloMultiAssetBlackScholesModel(brownianMotion, initialValues, riskFreeRate, optimizer.getBestFitParameters(), correlations);
        HybridAssetLIBORModelMonteCarloSimulationFromModels hybridModelWithoutDiscountAdjustment = new HybridAssetLIBORModelMonteCarloSimulationFromModels(baseModel, model, null);
        for (int assetIndex = 0; assetIndex < volatilities.length; ++assetIndex) {
            EuropeanOption option;
            double valueOptoin;
            double df = hybridModelWithoutDiscountAdjustment.getNumeraire(maturities[assetIndex]).invert().getAverage();
            double spot = hybridModelWithoutDiscountAdjustment.getAssetValue(0.0, assetIndex).getAverage();
            double impliedVol = AnalyticFormulas.blackScholesOptionImpliedVolatility(spot / df, maturities[assetIndex], strikes[assetIndex], df, valueOptoin = (option = new EuropeanOption(maturities[assetIndex], strikes[assetIndex], assetIndex)).getValue(hybridModelWithoutDiscountAdjustment));
            if (!(Math.abs(impliedVol - volatilities[assetIndex]) > 0.01)) continue;
            throw new CalculationException("Calibration failed");
        }
        HybridAssetLIBORModelMonteCarloSimulationFromModels hybridModel = new HybridAssetLIBORModelMonteCarloSimulationFromModels(baseModel, model, discountCurve);
        return hybridModel;
    }
}

