/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate.products;

import java.time.LocalDateTime;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetMonteCarloSimulation;
import net.finmath.montecarlo.hybridassetinterestrate.products.HybridAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public class BondWithForeignNumeraire
extends HybridAssetMonteCarloProduct {
    private final LocalDateTime referenceDate;
    private final String account;
    private final double maturity;

    public BondWithForeignNumeraire(LocalDateTime referenceDate, String account, double maturity) {
        this.referenceDate = referenceDate;
        this.account = account;
        this.maturity = maturity;
    }

    public BondWithForeignNumeraire(String account, double maturity) {
        this(null, account, maturity);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, HybridAssetMonteCarloSimulation model) throws CalculationException {
        double productToModelTimeOffset = 0.0;
        try {
            if (this.referenceDate != null) {
                productToModelTimeOffset = FloatingpointDate.getFloatingPointDateFromDate(model.getReferenceDate(), this.referenceDate);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        RandomVariable numeraire = model.getNumeraire(this.account, productToModelTimeOffset + this.maturity);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(productToModelTimeOffset + this.maturity);
        RandomVariable values = model.getRandomVariableForConstant(1.0);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(this.account, evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }

    public double getMaturity() {
        return this.maturity;
    }
}

