/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.modelling.Model;
import net.finmath.modelling.Product;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetLIBORModelMonteCarloSimulation;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class WorstOfExpressCertificate
implements Product {
    private final double maturity;
    private final double[] strikeLevels;
    private final double[] exerciseDates;
    private final double[] triggerPerformanceLevel;
    private final double[] redemption;
    private final double redemptionFinal;

    public WorstOfExpressCertificate(double maturity, double[] baseLevels, double[] exerciseDates, double[] triggerLevels, double[] redemption, double redemptionFinal) {
        this.maturity = maturity;
        this.strikeLevels = baseLevels;
        this.exerciseDates = exerciseDates;
        this.triggerPerformanceLevel = triggerLevels;
        this.redemption = redemption;
        this.redemptionFinal = redemptionFinal;
    }

    @Override
    public Object getValue(double evaluationTime, Model model) {
        return null;
    }

    public double getValue(double evaluationTime, HybridAssetLIBORModelMonteCarloSimulation model) throws CalculationException {
        RandomVariable zero = model.getRandomVariableForConstant(0.0);
        RandomVariable values = model.getRandomVariableForConstant(0.0);
        RandomVariable exerciseIndicator = model.getRandomVariableForConstant(1.0);
        for (int triggerIndex = 0; triggerIndex < this.exerciseDates.length; ++triggerIndex) {
            RandomVariable worstPerformance = WorstOfExpressCertificate.getWorstPerformance(model, this.exerciseDates[triggerIndex], this.strikeLevels);
            RandomVariable trigger = worstPerformance.sub(this.triggerPerformanceLevel[triggerIndex]);
            RandomVariable payment = exerciseIndicator.mult(this.redemption[triggerIndex]);
            payment = payment.div(model.getNumeraire(this.exerciseDates[triggerIndex]));
            values = values.add(trigger.choose(payment, new Scalar(0.0)));
            exerciseIndicator = trigger.choose(zero, exerciseIndicator);
        }
        RandomVariable worstPerformance = WorstOfExpressCertificate.getWorstPerformance(model, this.maturity, this.strikeLevels);
        RandomVariable payment = exerciseIndicator.mult(worstPerformance.mult(this.redemptionFinal));
        payment = payment.div(model.getNumeraire(this.maturity));
        values = values.add(payment);
        values = values.mult(model.getNumeraire(evaluationTime));
        return values.getAverage();
    }

    private static RandomVariable getWorstPerformance(HybridAssetLIBORModelMonteCarloSimulation model, double exerciseDate, double[] baseLevels) throws CalculationException {
        RandomVariable worstPerformance = null;
        for (int assetIndex = 0; assetIndex < baseLevels.length; ++assetIndex) {
            RandomVariable underlying = model.getAssetValue(exerciseDate, assetIndex);
            RandomVariable performance = underlying.div(baseLevels[assetIndex]);
            worstPerformance = worstPerformance != null ? worstPerformance.cap(performance) : performance;
        }
        return worstPerformance;
    }
}

