/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import net.finmath.montecarlo.interestrate.products.AbstractTermStructureMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class CalibrationProduct {
    private final String name;
    private final AbstractTermStructureMonteCarloProduct product;
    private final RandomVariable targetValue;
    private final double weight;
    private final Integer priority;

    public CalibrationProduct(String name, AbstractTermStructureMonteCarloProduct product, RandomVariable targetValue, double weight, int priority) {
        this.name = name;
        this.product = product;
        this.targetValue = targetValue;
        this.weight = weight;
        this.priority = priority;
    }

    public CalibrationProduct(String name, AbstractTermStructureMonteCarloProduct product, RandomVariable targetValue, double weight) {
        this(name, product, targetValue, weight, 0);
    }

    public CalibrationProduct(String name, AbstractTermStructureMonteCarloProduct product, double targetValue, double weight) {
        this(name, product, new Scalar(targetValue), weight);
    }

    public CalibrationProduct(AbstractTermStructureMonteCarloProduct product, RandomVariable targetValue, double weight) {
        this(null, product, targetValue, weight);
    }

    public CalibrationProduct(AbstractTermStructureMonteCarloProduct product, double targetValue, double weight) {
        this(product, new Scalar(targetValue), weight);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.product.toString();
    }

    public AbstractTermStructureMonteCarloProduct getProduct() {
        return this.product;
    }

    public RandomVariable getTargetValue() {
        return this.targetValue;
    }

    public double getWeight() {
        return this.weight;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String toString() {
        return "CalibrationProduct [product=" + this.getProduct() + ", targetValue=" + this.getTargetValue() + ", weight=" + this.getWeight() + "]";
    }
}

