/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.montecarlo.process.MonteCarloProcessFromProcessModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class TermStructureMonteCarloSimulationFromTermStructureModel
implements TermStructureMonteCarloSimulationModel {
    private final TermStructureModel model;
    private final MonteCarloProcess process;

    public TermStructureMonteCarloSimulationFromTermStructureModel(TermStructureModel model, MonteCarloProcess process) {
        this.model = model;
        this.process = process;
    }

    public TermStructureMonteCarloSimulationFromTermStructureModel(MonteCarloProcess process) {
        this((TermStructureModel)process.getModel(), process);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1 - 1;
        }
        return this.process.getMonteCarloWeights(timeIndex);
    }

    @Override
    public int getNumberOfFactors() {
        return this.process.getNumberOfFactors();
    }

    @Override
    public int getNumberOfPaths() {
        return this.process.getNumberOfPaths();
    }

    @Override
    public LocalDateTime getReferenceDate() {
        throw new UnsupportedOperationException("This model does not provide a reference date. Reference dates will be mandatory in a future version.");
    }

    @Override
    public double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    @Override
    public int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.process.getStochasticDriver().getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariable getForwardRate(double time, double periodStart, double periodEnd) throws CalculationException {
        return this.model.getForwardRate(this.process, time, periodStart, periodEnd);
    }

    public int getNumberOfComponents() {
        return this.model.getNumberOfComponents();
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public TermStructureModel getModel() {
        return this.model;
    }

    @Override
    public MonteCarloProcess getProcess() {
        return this.process;
    }

    @Override
    public Object getCloneWithModifiedSeed(int seed) {
        MonteCarloProcessFromProcessModel process = (MonteCarloProcessFromProcessModel)((MonteCarloProcessFromProcessModel)this.getProcess()).getCloneWithModifiedSeed(seed);
        return new TermStructureMonteCarloSimulationFromTermStructureModel(this.model, process);
    }

    @Override
    public TermStructureMonteCarloSimulationModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        ProcessModel modelClone = this.model.getCloneWithModifiedData((Map)dataModified);
        if (dataModified.containsKey("discountCurve") && dataModified.size() == 1) {
            TermStructureMonteCarloSimulationFromTermStructureModel lmmSimClone = new TermStructureMonteCarloSimulationFromTermStructureModel((TermStructureModel)modelClone, this.process);
            return lmmSimClone;
        }
        return new TermStructureMonteCarloSimulationFromTermStructureModel((TermStructureModel)modelClone, this.getProcess().clone());
    }

    public TermStructureMonteCarloSimulationModel getCloneWithModifiedData(String entityKey, Object dataModified) throws CalculationException {
        HashMap<String, Object> dataModifiedMap = new HashMap<String, Object>();
        dataModifiedMap.put(entityKey, dataModified);
        return this.getCloneWithModifiedData(dataModifiedMap);
    }

    @Override
    public Map<String, RandomVariable> getModelParameters() {
        throw new UnsupportedOperationException();
    }
}

