/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.SwaptionMarketData;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.CalibrationProduct;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModelCalibrateable;
import net.finmath.montecarlo.interestrate.products.AbstractTermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.RegularSchedule;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class LIBORMarketModelFromCovarianceModel
extends AbstractProcessModel
implements LIBORMarketModel,
Serializable {
    private static final long serialVersionUID = 4166077559001066615L;
    private final TimeDiscretization liborPeriodDiscretization;
    private final AnalyticModel curveModel;
    private final ForwardCurve forwardRateCurve;
    private final DiscountCurve discountCurve;
    private final RandomVariableFactory randomVariableFactory;
    private LIBORCovarianceModel covarianceModel;
    private SwaptionMarketData swaptionMarketData;
    private final Driftapproximation driftApproximationMethod = Driftapproximation.EULER;
    private Measure measure = Measure.SPOT;
    private StateSpace stateSpace = StateSpace.LOGNORMAL;
    private SimulationTimeInterpolationMethod simulationTimeInterpolationMethod = SimulationTimeInterpolationMethod.ROUND_NEAREST;
    private InterpolationMethod interpolationMethod = InterpolationMethod.LOG_LINEAR_UNCORRECTED;
    private double liborCap = 100000.0;
    private double[][][] integratedLIBORCovariance;
    private transient Object integratedLIBORCovarianceLazyInitLock = new Object();
    private transient MonteCarloProcess numerairesProcess = null;
    private transient ConcurrentHashMap<Integer, RandomVariable> numeraires = new ConcurrentHashMap();
    private transient ConcurrentHashMap<Double, RandomVariable> numeraireDiscountFactorForwardRates = new ConcurrentHashMap();
    private transient ConcurrentHashMap<Double, RandomVariable> numeraireDiscountFactors = new ConcurrentHashMap();
    private transient Vector<RandomVariable> interpolationDriftAdjustmentsTerminal = new Vector();

    public static LIBORMarketModelFromCovarianceModel of(TimeDiscretization liborPeriodDiscretization, AnalyticModel analyticModel, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, RandomVariableFactory randomVariableFactory, LIBORCovarianceModel covarianceModel, CalibrationProduct[] calibrationProducts, Map<String, ?> properties) throws CalculationException {
        LIBORMarketModelFromCovarianceModel model = new LIBORMarketModelFromCovarianceModel(liborPeriodDiscretization, analyticModel, forwardRateCurve, discountCurve, randomVariableFactory, covarianceModel, properties);
        if (calibrationProducts != null && calibrationProducts.length > 0) {
            Map calibrationParameters = null;
            if (properties != null && properties.containsKey("calibrationParameters")) {
                Map calibrationParametersProperty;
                calibrationParameters = calibrationParametersProperty = (Map)properties.get("calibrationParameters");
            }
            LIBORCovarianceModelCalibrateable covarianceModelParametric = null;
            try {
                covarianceModelParametric = (LIBORCovarianceModelCalibrateable)covarianceModel;
            }
            catch (Exception e) {
                throw new ClassCastException("Calibration restricted to covariance models implementing LIBORCovarianceModelCalibrateable.");
            }
            LIBORCovarianceModelCalibrateable covarianceModelCalibrated = covarianceModelParametric.getCloneCalibrated(model, calibrationProducts, calibrationParameters);
            LIBORMarketModelFromCovarianceModel modelCalibrated = model.getCloneWithModifiedCovarianceModel(covarianceModelCalibrated);
            return modelCalibrated;
        }
        return model;
    }

    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, AnalyticModel analyticModel, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, RandomVariableFactory randomVariableFactory, LIBORCovarianceModel covarianceModel, CalibrationProduct[] calibrationProducts, Map<String, ?> properties) throws CalculationException {
        if (properties != null && properties.containsKey("measure")) {
            this.measure = Measure.valueOf(((String)properties.get("measure")).toUpperCase());
        }
        if (properties != null && properties.containsKey("stateSpace")) {
            this.stateSpace = StateSpace.valueOf(((String)properties.get("stateSpace")).toUpperCase());
        }
        if (properties != null && properties.containsKey("interpolationMethod")) {
            this.interpolationMethod = InterpolationMethod.valueOf(((String)properties.get("interpolationMethod")).toUpperCase());
        }
        if (properties != null && properties.containsKey("simulationTimeInterpolationMethod")) {
            this.simulationTimeInterpolationMethod = SimulationTimeInterpolationMethod.valueOf(((String)properties.get("simulationTimeInterpolationMethod")).toUpperCase());
        }
        if (properties != null && properties.containsKey("liborCap")) {
            this.liborCap = (Double)properties.get("liborCap");
        }
        Map calibrationParameters = null;
        if (properties != null && properties.containsKey("calibrationParameters")) {
            Map calibrationParametersProperty;
            calibrationParameters = calibrationParametersProperty = (Map)properties.get("calibrationParameters");
        }
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.curveModel = analyticModel;
        this.forwardRateCurve = forwardRateCurve;
        this.discountCurve = discountCurve;
        this.randomVariableFactory = randomVariableFactory;
        if (calibrationProducts != null && calibrationProducts.length > 0) {
            LIBORCovarianceModelCalibrateable covarianceModelParametric = null;
            try {
                covarianceModelParametric = (LIBORCovarianceModelCalibrateable)covarianceModel;
            }
            catch (Exception e) {
                throw new ClassCastException("Calibration restricted to covariance models implementing LIBORCovarianceModelCalibrateable.");
            }
            this.covarianceModel = covarianceModelParametric.getCloneCalibrated(this, calibrationProducts, calibrationParameters);
        } else {
            this.covarianceModel = covarianceModel;
        }
    }

    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, AnalyticModel analyticModel, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, RandomVariableFactory randomVariableFactory, LIBORCovarianceModel covarianceModel, Map<String, ?> properties) throws CalculationException {
        this(liborPeriodDiscretization, analyticModel, forwardRateCurve, discountCurve, randomVariableFactory, covarianceModel, null, properties);
    }

    @Deprecated
    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, AnalyticModel analyticModel, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, LIBORCovarianceModel covarianceModel, CalibrationProduct[] calibrationItems, Map<String, ?> properties) throws CalculationException {
        this(liborPeriodDiscretization, analyticModel, forwardRateCurve, discountCurve, new RandomVariableFromArrayFactory(), covarianceModel, calibrationItems, properties);
    }

    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, LIBORCovarianceModel covarianceModel) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, (DiscountCurve)new DiscountCurveFromForwardCurve(forwardRateCurve), covarianceModel, new CalibrationProduct[0], null);
    }

    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, LIBORCovarianceModel covarianceModel) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, new CalibrationProduct[0], null);
    }

    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, LIBORCovarianceModel covarianceModel, SwaptionMarketData swaptionMarketData) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, (DiscountCurve)new DiscountCurveFromForwardCurve(forwardRateCurve), covarianceModel, swaptionMarketData, null);
    }

    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, LIBORCovarianceModel covarianceModel, SwaptionMarketData swaptionMarketData) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, swaptionMarketData, null);
    }

    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, LIBORCovarianceModel covarianceModel, SwaptionMarketData swaptionMarketData, Map<String, ?> properties) throws CalculationException {
        this(liborPeriodDiscretization, forwardRateCurve, discountCurve, covarianceModel, LIBORMarketModelFromCovarianceModel.getCalibrationItems(liborPeriodDiscretization, forwardRateCurve, swaptionMarketData, (properties == null || properties.get("stateSpace") == null || ((String)properties.get("stateSpace")).toUpperCase().equals(StateSpace.LOGNORMAL.name())) && AbstractLIBORCovarianceModelParametric.class.isAssignableFrom(covarianceModel.getClass())), properties);
    }

    @Deprecated
    public LIBORMarketModelFromCovarianceModel(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardRateCurve, DiscountCurve discountCurve, LIBORCovarianceModel covarianceModel, CalibrationProduct[] calibrationItems, Map<String, ?> properties) throws CalculationException {
        this(liborPeriodDiscretization, null, forwardRateCurve, discountCurve, covarianceModel, calibrationItems, properties);
    }

    private static CalibrationProduct[] getCalibrationItems(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardCurve, SwaptionMarketData swaptionMarketData, boolean isUseAnalyticApproximation) {
        if (swaptionMarketData == null) {
            return null;
        }
        TimeDiscretization optionMaturities = swaptionMarketData.getOptionMaturities();
        TimeDiscretization tenor = swaptionMarketData.getTenor();
        double swapPeriodLength = swaptionMarketData.getSwapPeriodLength();
        ArrayList<CalibrationProduct> calibrationProducts = new ArrayList<CalibrationProduct>();
        for (int exerciseIndex = 0; exerciseIndex <= optionMaturities.getNumberOfTimeSteps(); ++exerciseIndex) {
            for (int tenorIndex = 0; tenorIndex <= tenor.getNumberOfTimeSteps() - exerciseIndex; ++tenorIndex) {
                AbstractTermStructureMonteCarloProduct swaption;
                double exerciseDate = optionMaturities.getTime(exerciseIndex);
                double swapLength = tenor.getTime(tenorIndex);
                if (liborPeriodDiscretization.getTimeIndex(exerciseDate) < 0 || liborPeriodDiscretization.getTimeIndex(exerciseDate + swapLength) <= liborPeriodDiscretization.getTimeIndex(exerciseDate)) continue;
                int numberOfPeriods = (int)(swapLength / swapPeriodLength);
                double[] fixingDates = new double[numberOfPeriods];
                double[] paymentDates = new double[numberOfPeriods];
                double[] swapTenorTimes = new double[numberOfPeriods + 1];
                for (int periodStartIndex = 0; periodStartIndex < numberOfPeriods; ++periodStartIndex) {
                    fixingDates[periodStartIndex] = exerciseDate + (double)periodStartIndex * swapPeriodLength;
                    paymentDates[periodStartIndex] = exerciseDate + (double)(periodStartIndex + 1) * swapPeriodLength;
                    swapTenorTimes[periodStartIndex] = exerciseDate + (double)periodStartIndex * swapPeriodLength;
                }
                swapTenorTimes[numberOfPeriods] = exerciseDate + (double)numberOfPeriods * swapPeriodLength;
                RegularSchedule swapTenor = new RegularSchedule(new TimeDiscretizationFromArray(swapTenorTimes));
                double swaprate = Swap.getForwardSwapRate(swapTenor, swapTenor, forwardCurve, null);
                double[] swaprates = new double[numberOfPeriods];
                for (int periodStartIndex = 0; periodStartIndex < numberOfPeriods; ++periodStartIndex) {
                    swaprates[periodStartIndex] = swaprate;
                }
                if (isUseAnalyticApproximation) {
                    swaption = new SwaptionAnalyticApproximation(swaprate, swapTenorTimes, Swaption.ValueUnit.VOLATILITYLOGNORMAL);
                    double impliedVolatility = swaptionMarketData.getVolatility(exerciseDate, swapLength, swaptionMarketData.getSwapPeriodLength(), swaprate);
                    calibrationProducts.add(new CalibrationProduct(swaption, impliedVolatility, 1.0));
                    continue;
                }
                swaption = new SwaptionSimple(swaprate, swapTenorTimes, Swaption.ValueUnit.VALUE);
                double forwardSwaprate = Swap.getForwardSwapRate(swapTenor, swapTenor, forwardCurve);
                double swapAnnuity = SwapAnnuity.getSwapAnnuity((Schedule)swapTenor, forwardCurve);
                double impliedVolatility = swaptionMarketData.getVolatility(exerciseDate, swapLength, swaptionMarketData.getSwapPeriodLength(), swaprate);
                double targetValue = AnalyticFormulas.blackModelSwaptionValue(forwardSwaprate, impliedVolatility, exerciseDate, swaprate, swapAnnuity);
                calibrationProducts.add(new CalibrationProduct(swaption, targetValue, 1.0));
            }
        }
        return calibrationProducts.toArray(new CalibrationProduct[calibrationProducts.size()]);
    }

    @Override
    public LocalDateTime getReferenceDate() {
        return this.forwardRateCurve.getReferenceDate() != null ? this.forwardRateCurve.getReferenceDate().atStartOfDay() : null;
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) throws CalculationException {
        if (time < 0.0) {
            return this.randomVariableFactory.createRandomVariable(this.discountCurve.getDiscountFactor(this.curveModel, time));
        }
        RandomVariable numeraire = this.getNumerairetUnAdjusted(process, time);
        if (this.discountCurve != null) {
            RandomVariable defaultableZeroBondAsOfTimeZero = this.getNumeraireDefaultableZeroBondAsOfTimeZero(process, time);
            double nonDefaultableZeroBond = numeraire.invert().mult(this.getNumerairetUnAdjusted(process, 0.0)).getAverage();
            numeraire = numeraire.mult(nonDefaultableZeroBond).div(defaultableZeroBondAsOfTimeZero);
        }
        return numeraire;
    }

    private RandomVariable getNumeraireDefaultableZeroBondAsOfTimeZero(MonteCarloProcess process, double time) {
        boolean isInterpolateDiscountFactorsOnLiborPeriodDiscretization = true;
        TimeDiscretization timeDiscretizationForCurves = this.liborPeriodDiscretization;
        int timeIndex = timeDiscretizationForCurves.getTimeIndex(time);
        if (timeIndex >= 0) {
            return this.getNumeraireDefaultableZeroBondAsOfTimeZero(process, timeIndex);
        }
        int timeIndexPrev = Math.min(-timeIndex - 2, this.getLiborPeriodDiscretization().getNumberOfTimes() - 2);
        int timeIndexNext = timeIndexPrev + 1;
        double timePrev = timeDiscretizationForCurves.getTime(timeIndexPrev);
        double timeNext = timeDiscretizationForCurves.getTime(timeIndexNext);
        RandomVariable numeraireAdjustmentPrev = this.getNumeraireDefaultableZeroBondAsOfTimeZero(process, timeIndexPrev);
        RandomVariable numeraireAdjustmentNext = this.getNumeraireDefaultableZeroBondAsOfTimeZero(process, timeIndexNext);
        return numeraireAdjustmentPrev.mult(numeraireAdjustmentNext.div(numeraireAdjustmentPrev).pow((time - timePrev) / (timeNext - timePrev)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomVariable getNumeraireDefaultableZeroBondAsOfTimeZero(MonteCarloProcess process, int timeIndex) {
        boolean isInterpolateDiscountFactorsOnLiborPeriodDiscretization = true;
        TimeDiscretization timeDiscretizationForCurves = this.liborPeriodDiscretization;
        double time = timeDiscretizationForCurves.getTime(timeIndex);
        ConcurrentHashMap<Double, RandomVariable> concurrentHashMap = this.numeraireDiscountFactorForwardRates;
        synchronized (concurrentHashMap) {
            this.ensureCacheConsistency(process);
            RandomVariable deterministicNumeraireAdjustment = this.numeraireDiscountFactors.get(time);
            if (deterministicNumeraireAdjustment == null) {
                double dfInitial = this.discountCurve.getDiscountFactor(this.curveModel, timeDiscretizationForCurves.getTime(0));
                deterministicNumeraireAdjustment = this.randomVariableFactory.createRandomVariable(dfInitial);
                this.numeraireDiscountFactors.put(timeDiscretizationForCurves.getTime(0), deterministicNumeraireAdjustment);
                for (int i = 0; i < timeDiscretizationForCurves.getNumberOfTimeSteps(); ++i) {
                    double dfPrev = this.discountCurve.getDiscountFactor(this.curveModel, timeDiscretizationForCurves.getTime(i));
                    double dfNext = this.discountCurve.getDiscountFactor(this.curveModel, timeDiscretizationForCurves.getTime(i + 1));
                    double timeStep = timeDiscretizationForCurves.getTimeStep(i);
                    double timeNext = timeDiscretizationForCurves.getTime(i + 1);
                    RandomVariable forwardRate = this.randomVariableFactory.createRandomVariable((dfPrev / dfNext - 1.0) / timeStep);
                    this.numeraireDiscountFactorForwardRates.put(timeDiscretizationForCurves.getTime(i), forwardRate);
                    deterministicNumeraireAdjustment = deterministicNumeraireAdjustment.discount(forwardRate, timeStep);
                    this.numeraireDiscountFactors.put(timeNext, deterministicNumeraireAdjustment);
                }
                deterministicNumeraireAdjustment = this.numeraireDiscountFactors.get(time);
            }
            return deterministicNumeraireAdjustment;
        }
    }

    @Override
    public RandomVariable getForwardDiscountBond(MonteCarloProcess process, double time, double maturity) throws CalculationException {
        RandomVariable inverseForwardBondAsOfTime = this.getForwardRate(process, time, time, maturity).mult(maturity - time).add(1.0);
        RandomVariable inverseForwardBondAsOfZero = this.getForwardRate(process, 0.0, time, maturity).mult(maturity - time).add(1.0);
        RandomVariable forwardDiscountBondAsOfZero = this.getNumeraireDefaultableZeroBondAsOfTimeZero(process, maturity).div(this.getNumeraireDefaultableZeroBondAsOfTimeZero(process, time));
        return forwardDiscountBondAsOfZero.mult(inverseForwardBondAsOfZero).div(inverseForwardBondAsOfTime);
    }

    private void ensureCacheConsistency(MonteCarloProcess process) {
        if (process != this.numerairesProcess) {
            this.numeraires.clear();
            this.numeraireDiscountFactorForwardRates.clear();
            this.numeraireDiscountFactors.clear();
            this.numerairesProcess = process;
            this.interpolationDriftAdjustmentsTerminal.clear();
        }
    }

    protected RandomVariable getNumerairetUnAdjusted(MonteCarloProcess process, double time) throws CalculationException {
        int liborTimeIndex = this.getLiborPeriodIndex(time);
        if (liborTimeIndex < 0) {
            RandomVariable numeraireUnadjusted;
            int upperIndex = -liborTimeIndex - 1;
            int lowerIndex = upperIndex - 1;
            if (lowerIndex < 0) {
                throw new IllegalArgumentException("Numeraire requested for time " + time + ". Unsupported");
            }
            if (this.measure == Measure.TERMINAL) {
                numeraireUnadjusted = this.getRandomVariableForConstant(1.0);
                for (int liborIndex = upperIndex; liborIndex <= this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1; ++liborIndex) {
                    RandomVariable libor = this.getLIBOR(process, process.getTimeIndex(Math.min(time, this.liborPeriodDiscretization.getTime(liborIndex))), liborIndex);
                    double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
                    numeraireUnadjusted = numeraireUnadjusted.discount(libor, periodLength);
                }
            } else if (this.measure == Measure.SPOT) {
                numeraireUnadjusted = this.getNumerairetUnAdjusted(process, this.getLiborPeriod(upperIndex));
            } else {
                throw new IllegalArgumentException("Numeraire not implemented for specified measure.");
            }
            numeraireUnadjusted = numeraireUnadjusted.discount(this.getForwardRate(process, time, time, this.getLiborPeriod(upperIndex)), this.getLiborPeriod(upperIndex) - time);
            return numeraireUnadjusted;
        }
        return this.getNumerairetUnAdjustedAtLIBORIndex(process, liborTimeIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomVariable getNumerairetUnAdjustedAtLIBORIndex(MonteCarloProcess process, int liborTimeIndex) throws CalculationException {
        ConcurrentHashMap<Integer, RandomVariable> concurrentHashMap = this.numeraires;
        synchronized (concurrentHashMap) {
            this.ensureCacheConsistency(process);
            RandomVariable numeraireUnadjusted = this.numeraires.get(liborTimeIndex);
            if (numeraireUnadjusted == null) {
                if (this.measure == Measure.TERMINAL) {
                    int timeIndex = process.getTimeIndex(this.liborPeriodDiscretization.getTime(liborTimeIndex));
                    if (timeIndex < 0) {
                        timeIndex = -timeIndex - 1;
                    }
                    numeraireUnadjusted = this.getRandomVariableForConstant(1.0);
                    for (int liborIndex = liborTimeIndex; liborIndex <= this.liborPeriodDiscretization.getNumberOfTimeSteps() - 1; ++liborIndex) {
                        RandomVariable forwardRate = this.getLIBOR(process, timeIndex, liborIndex);
                        double periodLength = this.liborPeriodDiscretization.getTimeStep(liborIndex);
                        numeraireUnadjusted = numeraireUnadjusted.discount(forwardRate, periodLength);
                    }
                } else if (this.measure == Measure.SPOT) {
                    if (liborTimeIndex != 0) {
                        int timeIndex = process.getTimeIndex(this.liborPeriodDiscretization.getTime(liborTimeIndex - 1));
                        if (timeIndex < 0) {
                            timeIndex = -timeIndex - 1;
                        }
                        double periodLength = this.liborPeriodDiscretization.getTimeStep(liborTimeIndex - 1);
                        RandomVariable forwardRate = this.getLIBOR(process, timeIndex, liborTimeIndex - 1);
                        numeraireUnadjusted = this.getNumerairetUnAdjustedAtLIBORIndex(process, liborTimeIndex - 1).accrue(forwardRate, periodLength);
                    } else {
                        numeraireUnadjusted = this.getRandomVariableForConstant(1.0);
                    }
                } else {
                    throw new IllegalArgumentException("Numeraire not implemented for specified measure.");
                }
                this.numeraires.put(liborTimeIndex, numeraireUnadjusted);
            }
            return numeraireUnadjusted;
        }
    }

    public Map<Double, RandomVariable> getNumeraireAdjustments() {
        return Collections.unmodifiableMap(this.numeraireDiscountFactorForwardRates);
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        double[] liborInitialStates = new double[this.liborPeriodDiscretization.getNumberOfTimeSteps()];
        for (int timeIndex = 0; timeIndex < this.liborPeriodDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double rate = this.forwardRateCurve.getForward(this.curveModel, this.liborPeriodDiscretization.getTime(timeIndex), this.liborPeriodDiscretization.getTimeStep(timeIndex));
            liborInitialStates[timeIndex] = this.stateSpace == StateSpace.LOGNORMAL ? Math.log(Math.max(rate, 0.0)) : rate;
        }
        RandomVariable[] initialStateRandomVariable = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            initialStateRandomVariable[componentIndex] = this.getRandomVariableForConstant(liborInitialStates[componentIndex]);
        }
        return initialStateRandomVariable;
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        int factorIndex;
        RandomVariable[] factorLoading;
        RandomVariable oneStepMeasureTransform;
        RandomVariable forwardRate;
        double periodLength;
        int componentIndex;
        double time = process.getTime(timeIndex);
        int firstForwardRateIndex = this.getLiborPeriodIndex(time) + 1;
        if (firstForwardRateIndex < 0) {
            firstForwardRateIndex = -firstForwardRateIndex - 1 + 1;
        }
        Scalar zero = Scalar.of(0.0);
        RandomVariable[] drift = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex2 = firstForwardRateIndex; componentIndex2 < this.getNumberOfComponents(); ++componentIndex2) {
            drift[componentIndex2] = zero;
        }
        Object[] factorLoadingsSums = new RandomVariable[this.getNumberOfFactors()];
        Arrays.fill(factorLoadingsSums, zero);
        if (this.measure == Measure.SPOT) {
            for (componentIndex = firstForwardRateIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                periodLength = this.getLiborPeriodDiscretization().getTimeStep(componentIndex);
                forwardRate = realizationAtTimeIndex[componentIndex];
                oneStepMeasureTransform = Scalar.of(periodLength).discount(forwardRate, periodLength);
                if (this.stateSpace == StateSpace.LOGNORMAL) {
                    oneStepMeasureTransform = oneStepMeasureTransform.mult(forwardRate);
                }
                factorLoading = this.getFactorLoading(process, timeIndex, componentIndex, realizationAtTimeIndex);
                for (factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                    factorLoadingsSums[factorIndex] = factorLoadingsSums[factorIndex].addProduct(oneStepMeasureTransform, factorLoading[factorIndex]);
                }
                drift[componentIndex] = drift[componentIndex].addSumProduct((RandomVariable[])factorLoadingsSums, factorLoading);
            }
        } else if (this.measure == Measure.TERMINAL) {
            for (componentIndex = this.getNumberOfComponents() - 1; componentIndex >= firstForwardRateIndex; --componentIndex) {
                periodLength = this.getLiborPeriodDiscretization().getTimeStep(componentIndex);
                forwardRate = realizationAtTimeIndex[componentIndex];
                oneStepMeasureTransform = Scalar.of(-periodLength).discount(forwardRate, periodLength);
                if (this.stateSpace == StateSpace.LOGNORMAL) {
                    oneStepMeasureTransform = oneStepMeasureTransform.mult(forwardRate);
                }
                factorLoading = this.getFactorLoading(process, timeIndex, componentIndex, realizationAtTimeIndex);
                drift[componentIndex] = drift[componentIndex].addSumProduct((RandomVariable[])factorLoadingsSums, factorLoading);
                for (factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
                    factorLoadingsSums[factorIndex] = factorLoadingsSums[factorIndex].addProduct(oneStepMeasureTransform, factorLoading[factorIndex]);
                }
            }
        } else {
            throw new IllegalArgumentException("Drift not implemented for specified measure.");
        }
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            for (componentIndex = firstForwardRateIndex; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                RandomVariable variance = this.covarianceModel.getCovariance(time, componentIndex, componentIndex, realizationAtTimeIndex);
                drift[componentIndex] = drift[componentIndex].addProduct(variance, -0.5);
            }
        }
        return drift;
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
        return this.covarianceModel.getFactorLoading(process.getTime(timeIndex), this.getLiborPeriod(componentIndex), realizationAtTimeIndex);
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        RandomVariable value = randomVariable;
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            value = value.exp();
        }
        if (!Double.isInfinite(this.liborCap)) {
            value = value.cap(this.liborCap);
        }
        return value;
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        RandomVariable value = randomVariable;
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            value = value.log();
        }
        return value;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    public Driftapproximation getDriftApproximationMethod() {
        return this.driftApproximationMethod;
    }

    @Override
    public RandomVariable getForwardRate(MonteCarloProcess process, double time, double periodStart, double periodEnd) throws CalculationException {
        int periodStartIndex = this.getLiborPeriodIndex(periodStart);
        int periodEndIndex = this.getLiborPeriodIndex(periodEnd);
        int timeIndex = process.getTimeIndex(time = Math.min(time, periodStart));
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 2;
            if (this.simulationTimeInterpolationMethod == SimulationTimeInterpolationMethod.ROUND_NEAREST && time - process.getTime(timeIndex) > process.getTime(timeIndex + 1) - time) {
                ++timeIndex;
            }
        }
        if (periodEndIndex < 0) {
            int previousEndIndex = -periodEndIndex - 1 - 1;
            double nextEndTime = this.getLiborPeriod(previousEndIndex + 1);
            RandomVariable onePlusLongLIBORdt = this.getForwardRate(process, time, periodStart, nextEndTime).mult(nextEndTime - periodStart).add(1.0);
            RandomVariable onePlusInterpolatedLIBORDt = this.getOnePlusInterpolatedLIBORDt(process, timeIndex, periodEnd, previousEndIndex);
            return onePlusLongLIBORdt.div(onePlusInterpolatedLIBORDt).sub(1.0).div(periodEnd - periodStart);
        }
        if (periodStartIndex < 0) {
            int previousStartIndex = -periodStartIndex - 1 - 1;
            double nextStartTime = this.getLiborPeriod(previousStartIndex + 1);
            if (nextStartTime > periodEnd) {
                throw new AssertionError((Object)"Interpolation not possible.");
            }
            if (nextStartTime == periodEnd) {
                return this.getOnePlusInterpolatedLIBORDt(process, timeIndex, periodStart, previousStartIndex).sub(1.0).div(periodEnd - periodStart);
            }
            RandomVariable onePlusLongLIBORdt = this.getForwardRate(process, time, nextStartTime, periodEnd).mult(periodEnd - nextStartTime).add(1.0);
            RandomVariable onePlusInterpolatedLIBORDt = this.getOnePlusInterpolatedLIBORDt(process, timeIndex, periodStart, previousStartIndex);
            return onePlusLongLIBORdt.mult(onePlusInterpolatedLIBORDt).sub(1.0).div(periodEnd - periodStart);
        }
        if (periodStartIndex < 0 || periodEndIndex < 0) {
            throw new AssertionError((Object)"LIBOR requested outside libor discretization points and interpolation was not performed.");
        }
        if (periodStartIndex + 1 == periodEndIndex) {
            return this.getLIBOR(process, timeIndex, periodStartIndex);
        }
        RandomVariable accrualAccount = null;
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            double subPeriodLength = this.getLiborPeriod(periodIndex + 1) - this.getLiborPeriod(periodIndex);
            RandomVariable liborOverSubPeriod = this.getLIBOR(process, timeIndex, periodIndex);
            accrualAccount = accrualAccount == null ? liborOverSubPeriod.mult(subPeriodLength).add(1.0) : accrualAccount.accrue(liborOverSubPeriod, subPeriodLength);
        }
        RandomVariable libor = accrualAccount.sub(1.0).div(periodEnd - periodStart);
        return libor;
    }

    @Override
    public RandomVariable getLIBOR(MonteCarloProcess process, int timeIndex, int liborIndex) throws CalculationException {
        return process.getProcessValue(timeIndex, liborIndex);
    }

    private RandomVariable getOnePlusInterpolatedLIBORDt(MonteCarloProcess process, int timeIndex, double periodStartTime, int liborPeriodIndex) throws CalculationException {
        double analyticOnePlusInterpolatedLIBORDt;
        RandomVariable onePlusInterpolatedLIBORDt;
        double tenorPeriodStartTime = this.getLiborPeriod(liborPeriodIndex);
        double tenorPeriodEndTime = this.getLiborPeriod(liborPeriodIndex + 1);
        double tenorDt = tenorPeriodEndTime - tenorPeriodStartTime;
        if (tenorPeriodStartTime < process.getTime(timeIndex) && (timeIndex = Math.min(timeIndex, process.getTimeIndex(tenorPeriodStartTime))) < 0) {
            throw new IllegalArgumentException("Tenor discretization not part of time discretization.");
        }
        RandomVariable onePlusLongLIBORDt = this.getLIBOR(process, timeIndex, liborPeriodIndex).mult(tenorDt).add(1.0);
        double smallDt = tenorPeriodEndTime - periodStartTime;
        double alpha = smallDt / tenorDt;
        switch (this.interpolationMethod) {
            case LINEAR: {
                onePlusInterpolatedLIBORDt = onePlusLongLIBORDt.mult(alpha).add(1.0 - alpha);
                break;
            }
            case LOG_LINEAR_UNCORRECTED: {
                onePlusInterpolatedLIBORDt = onePlusLongLIBORDt.log().mult(alpha).exp();
                break;
            }
            case LOG_LINEAR_CORRECTED: {
                double adjustmentCoefficient = 0.5 * smallDt * (tenorPeriodStartTime - periodStartTime);
                RandomVariable adjustment = this.getInterpolationDriftAdjustment(process, timeIndex, liborPeriodIndex);
                adjustment = adjustment.mult(adjustmentCoefficient);
                onePlusInterpolatedLIBORDt = onePlusLongLIBORDt.log().mult(alpha).sub(adjustment).exp();
                break;
            }
            default: {
                throw new IllegalArgumentException("Method for enum " + this.interpolationMethod.name() + " not implemented!");
            }
        }
        double analyticOnePlusLongLIBORDt = 1.0 + this.getForwardRateCurve().getForward(this.getAnalyticModel(), tenorPeriodStartTime, tenorDt) * tenorDt;
        double analyticOnePlusShortLIBORDt = 1.0 + this.getForwardRateCurve().getForward(this.getAnalyticModel(), periodStartTime, smallDt) * smallDt;
        switch (this.interpolationMethod) {
            case LINEAR: {
                analyticOnePlusInterpolatedLIBORDt = analyticOnePlusLongLIBORDt * alpha + (1.0 - alpha);
                break;
            }
            case LOG_LINEAR_UNCORRECTED: 
            case LOG_LINEAR_CORRECTED: {
                analyticOnePlusInterpolatedLIBORDt = Math.exp(Math.log(analyticOnePlusLongLIBORDt) * alpha);
                break;
            }
            default: {
                throw new IllegalArgumentException("Method for enum " + this.interpolationMethod.name() + " not implemented!");
            }
        }
        onePlusInterpolatedLIBORDt = onePlusInterpolatedLIBORDt.mult(analyticOnePlusShortLIBORDt / analyticOnePlusInterpolatedLIBORDt);
        return onePlusInterpolatedLIBORDt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomVariable getInterpolationDriftAdjustment(MonteCarloProcess process, int evaluationTimeIndex, int liborIndex) throws CalculationException {
        switch (this.interpolationMethod) {
            case LINEAR: 
            case LOG_LINEAR_UNCORRECTED: {
                return null;
            }
            case LOG_LINEAR_CORRECTED: {
                double tenorPeriodStartTime = this.getLiborPeriod(liborIndex);
                int tenorPeriodStartIndex = process.getTimeIndex(tenorPeriodStartTime);
                if (tenorPeriodStartIndex < 0) {
                    tenorPeriodStartIndex = -tenorPeriodStartIndex - 2;
                }
                if (evaluationTimeIndex == tenorPeriodStartIndex) {
                    Vector<RandomVariable> vector = this.interpolationDriftAdjustmentsTerminal;
                    synchronized (vector) {
                        RandomVariable interpolationDriftAdjustment;
                        this.ensureCacheConsistency(process);
                        if (this.interpolationDriftAdjustmentsTerminal.size() <= liborIndex) {
                            this.interpolationDriftAdjustmentsTerminal.setSize(this.getNumberOfLibors());
                        }
                        if ((interpolationDriftAdjustment = this.interpolationDriftAdjustmentsTerminal.get(liborIndex)) == null) {
                            interpolationDriftAdjustment = this.getInterpolationDriftAdjustmentEvaluated(process, evaluationTimeIndex, liborIndex);
                            this.interpolationDriftAdjustmentsTerminal.set(liborIndex, interpolationDriftAdjustment);
                        }
                        return interpolationDriftAdjustment;
                    }
                }
                return this.getInterpolationDriftAdjustmentEvaluated(process, evaluationTimeIndex, liborIndex);
            }
        }
        throw new IllegalArgumentException("Method for enum " + this.interpolationMethod.name() + " not implemented!");
    }

    private RandomVariable getInterpolationDriftAdjustmentEvaluated(MonteCarloProcess process, int evaluationTimeIndex, int liborIndex) throws CalculationException {
        RandomVariable[] factorLoading;
        double tenorPeriodStartTime = this.getLiborPeriod(liborIndex);
        double tenorPeriodEndTime = this.getLiborPeriod(liborIndex + 1);
        double tenorDt = tenorPeriodEndTime - tenorPeriodStartTime;
        RandomVariable driftAdjustment = this.getRandomVariableForConstant(0.0);
        RandomVariable previousIntegrand = this.getRandomVariableForConstant(0.0);
        RandomVariable[] realizationsAtZero = new RandomVariable[this.getNumberOfLibors()];
        for (int liborIndexForRealization = 0; liborIndexForRealization < this.getNumberOfLibors(); ++liborIndexForRealization) {
            realizationsAtZero[liborIndexForRealization] = this.getLIBOR(process, 0, liborIndexForRealization);
        }
        for (RandomVariable oneFactor : factorLoading = this.getFactorLoading(process, 0, liborIndex, realizationsAtZero)) {
            previousIntegrand = previousIntegrand.add(oneFactor.squared());
        }
        previousIntegrand = previousIntegrand.div(realizationsAtZero[liborIndex].mult(tenorDt).add(1.0).squared());
        if (this.stateSpace == StateSpace.LOGNORMAL) {
            previousIntegrand = previousIntegrand.mult(realizationsAtZero[liborIndex].squared());
        }
        for (int sumTimeIndex = 1; sumTimeIndex <= evaluationTimeIndex; ++sumTimeIndex) {
            RandomVariable[] realizationsAtTimeIndex = new RandomVariable[this.getNumberOfLibors()];
            for (int liborIndexForRealization = 0; liborIndexForRealization < this.getNumberOfLibors(); ++liborIndexForRealization) {
                int evaluationTimeIndexForRealizations = Math.min(sumTimeIndex, process.getTimeIndex(this.getLiborPeriod(liborIndexForRealization)));
                if (evaluationTimeIndexForRealizations < 0) {
                    evaluationTimeIndexForRealizations = -evaluationTimeIndexForRealizations - 2;
                }
                realizationsAtTimeIndex[liborIndexForRealization] = this.getLIBOR(process, evaluationTimeIndexForRealizations, liborIndexForRealization);
            }
            RandomVariable[] factorLoadingAtTimeIndex = this.getFactorLoading(process, sumTimeIndex, liborIndex, realizationsAtTimeIndex);
            RandomVariable integrand = this.getRandomVariableForConstant(0.0);
            for (RandomVariable oneFactor : factorLoadingAtTimeIndex) {
                integrand = integrand.add(oneFactor.squared());
            }
            integrand = integrand.div(realizationsAtTimeIndex[liborIndex].mult(tenorDt).add(1.0).squared());
            if (this.stateSpace == StateSpace.LOGNORMAL) {
                integrand = integrand.mult(realizationsAtTimeIndex[liborIndex].squared());
            }
            double integralDt = 0.5 * (process.getTime(sumTimeIndex) - process.getTime(sumTimeIndex - 1));
            driftAdjustment = driftAdjustment.add(integrand.add(previousIntegrand).mult(integralDt));
            previousIntegrand = integrand;
        }
        return driftAdjustment;
    }

    @Override
    public int getNumberOfComponents() {
        return this.liborPeriodDiscretization.getNumberOfTimeSteps();
    }

    @Override
    public int getNumberOfLibors() {
        return this.getNumberOfComponents();
    }

    @Override
    public int getNumberOfFactors() {
        return this.covarianceModel.getNumberOfFactors();
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        if (timeIndex >= this.liborPeriodDiscretization.getNumberOfTimes() || timeIndex < 0) {
            throw new ArrayIndexOutOfBoundsException("Index for LIBOR period discretization out of bounds: " + timeIndex + ".");
        }
        return this.liborPeriodDiscretization.getTime(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborPeriodDiscretization.getTimeIndex(time);
    }

    @Override
    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][][] getIntegratedLIBORCovariance(TimeDiscretization simulationTimeDiscretization) {
        Object object = this.integratedLIBORCovarianceLazyInitLock;
        synchronized (object) {
            if (this.integratedLIBORCovariance == null) {
                int timeIndex;
                TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
                this.integratedLIBORCovariance = new double[simulationTimeDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()][liborPeriodDiscretization.getNumberOfTimeSteps()];
                for (timeIndex = 0; timeIndex < simulationTimeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
                    double dt = simulationTimeDiscretization.getTime(timeIndex + 1) - simulationTimeDiscretization.getTime(timeIndex);
                    RandomVariable[][] factorLoadings = new RandomVariable[liborPeriodDiscretization.getNumberOfTimeSteps()][];
                    for (int componentIndex = 0; componentIndex < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex) {
                        factorLoadings[componentIndex] = this.covarianceModel.getFactorLoading(simulationTimeDiscretization.getTime(timeIndex), liborPeriodDiscretization.getTime(componentIndex), null);
                    }
                    for (int componentIndex1 = 0; componentIndex1 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex1) {
                        RandomVariable[] factorLoadingOfComponent1 = factorLoadings[componentIndex1];
                        for (int componentIndex2 = componentIndex1; componentIndex2 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex2) {
                            double integratedLIBORCovarianceValue = 0.0;
                            if (this.getLiborPeriod(componentIndex1) > simulationTimeDiscretization.getTime(timeIndex)) {
                                RandomVariable[] factorLoadingOfComponent2 = factorLoadings[componentIndex2];
                                for (int factorIndex = 0; factorIndex < factorLoadingOfComponent2.length; ++factorIndex) {
                                    integratedLIBORCovarianceValue += factorLoadingOfComponent1[factorIndex].doubleValue() * factorLoadingOfComponent2[factorIndex].doubleValue() * dt;
                                }
                            }
                            this.integratedLIBORCovariance[timeIndex][componentIndex1][componentIndex2] = integratedLIBORCovarianceValue;
                        }
                    }
                }
                for (timeIndex = 1; timeIndex < simulationTimeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
                    double[][] prevIntegratedLIBORCovariance = this.integratedLIBORCovariance[timeIndex - 1];
                    double[][] thisIntegratedLIBORCovariance = this.integratedLIBORCovariance[timeIndex];
                    for (int componentIndex1 = 0; componentIndex1 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex1) {
                        for (int componentIndex2 = componentIndex1; componentIndex2 < liborPeriodDiscretization.getNumberOfTimeSteps(); ++componentIndex2) {
                            thisIntegratedLIBORCovariance[componentIndex1][componentIndex2] = prevIntegratedLIBORCovariance[componentIndex1][componentIndex2] + thisIntegratedLIBORCovariance[componentIndex1][componentIndex2];
                            thisIntegratedLIBORCovariance[componentIndex2][componentIndex1] = thisIntegratedLIBORCovariance[componentIndex1][componentIndex2];
                        }
                    }
                }
            }
        }
        return this.integratedLIBORCovariance;
    }

    @Override
    public AnalyticModel getAnalyticModel() {
        return this.curveModel;
    }

    @Override
    public DiscountCurve getDiscountCurve() {
        return this.discountCurve;
    }

    @Override
    public ForwardCurve getForwardRateCurve() {
        return this.forwardRateCurve;
    }

    public SwaptionMarketData getSwaptionMarketData() {
        return this.swaptionMarketData;
    }

    @Override
    public LIBORCovarianceModel getCovarianceModel() {
        return this.covarianceModel;
    }

    public Object clone() {
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("measure", this.measure.name());
            properties.put("stateSpace", this.stateSpace.name());
            properties.put("interpolationMethod", this.interpolationMethod.name());
            properties.put("liborCap", this.liborCap);
            return LIBORMarketModelFromCovarianceModel.of(this.getLiborPeriodDiscretization(), this.getAnalyticModel(), this.getForwardRateCurve(), this.getDiscountCurve(), this.randomVariableFactory, this.covarianceModel, null, properties);
        }
        catch (CalculationException e) {
            return null;
        }
    }

    @Override
    public LIBORMarketModelFromCovarianceModel getCloneWithModifiedCovarianceModel(LIBORCovarianceModel covarianceModel) {
        LIBORMarketModelFromCovarianceModel model = (LIBORMarketModelFromCovarianceModel)this.clone();
        model.covarianceModel = covarianceModel;
        return model;
    }

    @Override
    public LIBORMarketModelFromCovarianceModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        RandomVariableFactory randomVariableFactory = this.randomVariableFactory;
        TimeDiscretization liborPeriodDiscretization = this.liborPeriodDiscretization;
        AnalyticModel analyticModel = this.curveModel;
        ForwardCurve forwardRateCurve = this.forwardRateCurve;
        DiscountCurve discountCurve = this.discountCurve;
        LIBORCovarianceModel covarianceModel = this.covarianceModel;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("measure", this.measure.name());
        properties.put("stateSpace", this.stateSpace.name());
        properties.put("interpolationMethod", this.interpolationMethod.name());
        properties.put("liborCap", this.liborCap);
        if (dataModified != null) {
            randomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", randomVariableFactory);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            analyticModel = (AnalyticModel)dataModified.getOrDefault("analyticModel", analyticModel);
            forwardRateCurve = (ForwardCurve)dataModified.getOrDefault("forwardRateCurve", forwardRateCurve);
            discountCurve = (DiscountCurve)dataModified.getOrDefault("discountCurve", discountCurve);
            covarianceModel = (LIBORCovarianceModel)dataModified.getOrDefault("covarianceModel", covarianceModel);
            if (dataModified.containsKey("swaptionMarketData")) {
                throw new RuntimeException("Swaption market data as input for getCloneWithModifiedData not supported.");
            }
            if (dataModified.containsKey("forwardRateShift")) {
                try {
                    double[] forwardCurveValues = this.getForwardRateCurve().getParameter();
                    double[] forwardCurveValuesShift = (double[])dataModified.get("forwardRateShift");
                    double[] forwardCurveValuesShifted = new double[forwardCurveValues.length];
                    for (int i = 0; i < forwardCurveValues.length; ++i) {
                        forwardCurveValuesShifted[i] = forwardCurveValues[i] + forwardCurveValuesShift[i];
                    }
                    forwardRateCurve = (ForwardCurve)forwardRateCurve.getCloneForParameter(forwardCurveValuesShifted);
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException("Forward rate shift not supported.", e);
                }
            }
        }
        LIBORMarketModelFromCovarianceModel newModel = LIBORMarketModelFromCovarianceModel.of(liborPeriodDiscretization, analyticModel, forwardRateCurve, discountCurve, randomVariableFactory, covarianceModel, null, properties);
        return newModel;
    }

    @Override
    public Map<String, RandomVariable> getModelParameters() {
        MonteCarloProcess process = this.numerairesProcess;
        TreeMap<String, RandomVariable> modelParameters = new TreeMap<String, RandomVariable>();
        for (int liborIndex = 0; liborIndex < this.getLiborPeriodDiscretization().getNumberOfTimeSteps(); ++liborIndex) {
            RandomVariable forward = null;
            try {
                forward = this.getLIBOR(process, 0, liborIndex);
            }
            catch (CalculationException calculationException) {
                // empty catch block
            }
            modelParameters.put("FORWARD(" + this.getLiborPeriod(liborIndex) + "," + this.getLiborPeriod(liborIndex + 1) + ")", forward);
        }
        if (this.covarianceModel instanceof AbstractLIBORCovarianceModelParametric) {
            RandomVariable[] covarianceModelParameters = ((AbstractLIBORCovarianceModelParametric)this.covarianceModel).getParameter();
            for (int covarianceModelParameterIndex = 0; covarianceModelParameterIndex < covarianceModelParameters.length; ++covarianceModelParameterIndex) {
                modelParameters.put("COVARIANCEMODELPARAMETER(" + covarianceModelParameterIndex + ")", covarianceModelParameters[covarianceModelParameterIndex]);
            }
        }
        for (Map.Entry<Double, RandomVariable> numeraireAdjustment : this.numeraireDiscountFactorForwardRates.entrySet()) {
            modelParameters.put("NUMERAIREADJUSTMENT(" + numeraireAdjustment.getKey() + ")", numeraireAdjustment.getValue());
        }
        return modelParameters;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.integratedLIBORCovarianceLazyInitLock = new Object();
        this.numeraires = new ConcurrentHashMap();
        this.numeraireDiscountFactorForwardRates = new ConcurrentHashMap();
        this.numeraireDiscountFactors = new ConcurrentHashMap();
        this.interpolationDriftAdjustmentsTerminal = new Vector();
    }

    public String toString() {
        return "LIBORMarketModelFromCovarianceModel [liborPeriodDiscretization=" + this.liborPeriodDiscretization + ", curveModel=" + this.curveModel + ", forwardRateCurve=" + this.forwardRateCurve + ", discountCurve=" + this.discountCurve + ", covarianceModel=" + this.covarianceModel + ", driftApproximationMethod=" + this.driftApproximationMethod + ", measure=" + this.measure + ", stateSpace=" + this.stateSpace + "]";
    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }

    public static enum Measure {
        SPOT,
        TERMINAL;

    }

    public static enum StateSpace {
        NORMAL,
        LOGNORMAL;

    }

    public static enum SimulationTimeInterpolationMethod {
        ROUND_DOWN,
        ROUND_NEAREST;

    }

    public static enum InterpolationMethod {
        LINEAR,
        LOG_LINEAR_UNCORRECTED,
        LOG_LINEAR_CORRECTED;

    }
}

