/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.io.Serializable;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public abstract class AbstractLIBORCovarianceModel
implements Serializable,
LIBORCovarianceModel {
    private static final long serialVersionUID = 5364544247367259329L;
    private final TimeDiscretization timeDiscretization;
    private final TimeDiscretization liborPeriodDiscretization;
    private final int numberOfFactors;

    public AbstractLIBORCovarianceModel(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors) {
        this.timeDiscretization = timeDiscretization;
        this.liborPeriodDiscretization = liborPeriodDiscretization;
        this.numberOfFactors = numberOfFactors;
    }

    @Override
    public RandomVariable[] getFactorLoading(double time, double component, RandomVariable[] realizationAtTimeIndex) {
        int componentIndex = this.liborPeriodDiscretization.getTimeIndex(component);
        if (componentIndex < 0) {
            componentIndex = -componentIndex - 2;
        }
        return this.getFactorLoading(time, componentIndex, realizationAtTimeIndex);
    }

    @Override
    public RandomVariable[] getFactorLoading(double time, int component, RandomVariable[] realizationAtTimeIndex) {
        int timeIndex = this.timeDiscretization.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 2;
        }
        return this.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
    }

    @Override
    public abstract RandomVariable[] getFactorLoading(int var1, int var2, RandomVariable[] var3);

    @Override
    public abstract RandomVariable getFactorLoadingPseudoInverse(int var1, int var2, int var3, RandomVariable[] var4);

    @Override
    public RandomVariable getCovariance(double time, int component1, int component2, RandomVariable[] realizationAtTimeIndex) {
        int timeIndex = this.timeDiscretization.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = Math.abs(timeIndex) - 2;
        }
        return this.getCovariance(timeIndex, component1, component2, realizationAtTimeIndex);
    }

    @Override
    public RandomVariable getCovariance(int timeIndex, int component1, int component2, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factorLoadingOfComponent1 = this.getFactorLoading(timeIndex, component1, realizationAtTimeIndex);
        RandomVariable[] factorLoadingOfComponent2 = this.getFactorLoading(timeIndex, component2, realizationAtTimeIndex);
        RandomVariable covariance = factorLoadingOfComponent1[0].mult(factorLoadingOfComponent2[0]);
        for (int factorIndex = 1; factorIndex < this.getNumberOfFactors(); ++factorIndex) {
            covariance = covariance.addProduct(factorLoadingOfComponent1[factorIndex], factorLoadingOfComponent2[factorIndex]);
        }
        return covariance;
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public abstract AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> var1) throws CalculationException;
}

