/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.CalibrationProduct;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORMonteCarloSimulationFromLIBORModel;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModelCalibrateable;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.optimizer.Optimizer;
import net.finmath.optimizer.OptimizerFactory;
import net.finmath.optimizer.OptimizerFactoryLevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import net.finmath.optimizer.StochasticOptimizer;
import net.finmath.optimizer.StochasticOptimizerFactory;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public abstract class AbstractLIBORCovarianceModelParametric
extends AbstractLIBORCovarianceModel
implements LIBORCovarianceModelCalibrateable {
    private static final long serialVersionUID = 7015719361182945464L;
    private static final Logger logger = Logger.getLogger("net.finmath");

    public AbstractLIBORCovarianceModelParametric(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors) {
        super(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
    }

    public RandomVariable[] getParameter() {
        double[] parameterAsDouble = this.getParameterAsDouble();
        RandomVariable[] parameter = new RandomVariable[parameterAsDouble.length];
        for (int i = 0; i < parameter.length; ++i) {
            parameter[i] = new Scalar(parameterAsDouble[i]);
        }
        return parameter;
    }

    public abstract double[] getParameterAsDouble();

    public abstract Object clone();

    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        double[] parameterAsDouble = new double[parameters.length];
        for (int i = 0; i < parameterAsDouble.length; ++i) {
            parameterAsDouble[i] = parameters[i].doubleValue();
        }
        return this.getCloneWithModifiedParameters(parameterAsDouble);
    }

    public abstract AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] var1);

    public AbstractLIBORCovarianceModelParametric getCloneCalibrated(LIBORMarketModel calibrationModel, CalibrationProduct[] calibrationProducts) throws CalculationException {
        return this.getCloneCalibrated(calibrationModel, calibrationProducts, (Map)null);
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneCalibrated(final LIBORMarketModel calibrationModel, final CalibrationProduct[] calibrationProducts, Map<String, Object> calibrationParameters) throws CalculationException {
        if (calibrationParameters == null) {
            calibrationParameters = new HashMap<String, Object>();
        }
        int numberOfPaths = (Integer)calibrationParameters.getOrDefault("numberOfPaths", 2000);
        int seed = (Integer)calibrationParameters.getOrDefault("seed", 31415);
        int maxIterations = (Integer)calibrationParameters.getOrDefault("maxIterations", 400);
        double accuracy = (Double)calibrationParameters.getOrDefault("accuracy", 1.0E-7);
        final BrownianMotion brownianMotion = (BrownianMotion)calibrationParameters.getOrDefault("brownianMotion", new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), this.getNumberOfFactors(), numberOfPaths, seed));
        RandomVariable[] initialParameters = this.getParameter();
        Object[] lowerBound = new RandomVariable[initialParameters.length];
        Object[] upperBound = new RandomVariable[initialParameters.length];
        Object[] parameterStep = new RandomVariable[initialParameters.length];
        Arrays.fill(lowerBound, new RandomVariableFromDoubleArray(Double.NEGATIVE_INFINITY));
        Arrays.fill(upperBound, new RandomVariableFromDoubleArray(Double.POSITIVE_INFINITY));
        Double parameterStepParameter = (Double)calibrationParameters.get("parameterStep");
        Arrays.fill(parameterStep, new RandomVariableFromDoubleArray(parameterStepParameter != null ? parameterStepParameter : 1.0E-4));
        int numberOfThreadsForProductValuation = Runtime.getRuntime().availableProcessors();
        final ExecutorService executor = Executors.newFixedThreadPool(numberOfThreadsForProductValuation);
        StochasticOptimizer.ObjectiveFunction calibrationError = new StochasticOptimizer.ObjectiveFunction(){

            @Override
            public void setValues(RandomVariable[] parameters, RandomVariable[] values) throws SolverException {
                int calibrationProductIndex;
                AbstractLIBORCovarianceModelParametric calibrationCovarianceModel = AbstractLIBORCovarianceModelParametric.this.getCloneWithModifiedParameters(parameters);
                LIBORMarketModel model = calibrationModel.getCloneWithModifiedCovarianceModel(calibrationCovarianceModel);
                EulerSchemeFromProcessModel process = new EulerSchemeFromProcessModel(model, brownianMotion);
                final LIBORMonteCarloSimulationFromLIBORModel liborMarketModelMonteCarloSimulation = new LIBORMonteCarloSimulationFromLIBORModel(model, process);
                ArrayList<Future<RandomVariable>> valueFutures = new ArrayList<Future<RandomVariable>>(calibrationProducts.length);
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    final int workerCalibrationProductIndex = calibrationProductIndex;
                    Callable<RandomVariable> worker = new Callable<RandomVariable>(){

                        @Override
                        public RandomVariable call() {
                            try {
                                return calibrationProducts[workerCalibrationProductIndex].getProduct().getValue(0.0, liborMarketModelMonteCarloSimulation).sub(calibrationProducts[workerCalibrationProductIndex].getTargetValue()).mult(calibrationProducts[workerCalibrationProductIndex].getWeight());
                            }
                            catch (Exception e) {
                                return new Scalar(0.0);
                            }
                        }
                    };
                    if (executor != null) {
                        Future<RandomVariable> valueFuture = executor.submit(worker);
                        valueFutures.add(calibrationProductIndex, valueFuture);
                        continue;
                    }
                    FutureTask<RandomVariable> valueFutureTask = new FutureTask<RandomVariable>(worker);
                    valueFutureTask.run();
                    valueFutures.add(calibrationProductIndex, valueFutureTask);
                }
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    try {
                        RandomVariable value;
                        values[calibrationProductIndex] = value = (RandomVariable)((Future)valueFutures.get(calibrationProductIndex)).get();
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new SolverException(e);
                    }
                }
            }
        };
        int numberOfThreads = 2;
        Object optimizerFactory = calibrationParameters.getOrDefault("optimizerFactory", new OptimizerFactoryLevenbergMarquardt(maxIterations, accuracy, 2));
        AbstractLIBORCovarianceModelParametric calibrationCovarianceModel = null;
        if (optimizerFactory instanceof StochasticOptimizerFactory) {
            Object[] zerosForTargetValues = new RandomVariable[calibrationProducts.length];
            Arrays.fill(zerosForTargetValues, new RandomVariableFromDoubleArray(0.0));
            StochasticOptimizer optimizer = ((StochasticOptimizerFactory)optimizerFactory).getOptimizer(calibrationError, initialParameters, (RandomVariable[])lowerBound, (RandomVariable[])upperBound, (RandomVariable[])parameterStep, (RandomVariable[])zerosForTargetValues);
            try {
                optimizer.run();
            }
            catch (SolverException e) {
                throw new CalculationException(e);
            }
            finally {
                if (executor != null) {
                    executor.shutdown();
                }
            }
            RandomVariable[] bestParameters = optimizer.getBestFitParameters();
            int numberOfIterations = optimizer.getIterations();
            calibrationCovarianceModel = this.getCloneWithModifiedParameters(bestParameters);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("The solver required " + optimizer.getIterations() + " iterations. The best fit parameters are:");
                Object logString = "Best parameters:";
                for (int i = 0; i < bestParameters.length; ++i) {
                    logString = (String)logString + "\tparameter[" + i + "]: " + bestParameters[i];
                }
                logger.fine((String)logString);
            }
        } else {
            if (optimizerFactory instanceof OptimizerFactory) {
                return this.getCloneCalibratedLegazy(calibrationModel, calibrationProducts, calibrationParameters);
            }
            throw new IllegalArgumentException(optimizerFactory + " not supported.");
        }
        return calibrationCovarianceModel;
    }

    public AbstractLIBORCovarianceModelParametric getCloneCalibratedLegazy(final LIBORMarketModel calibrationModel, final CalibrationProduct[] calibrationProducts, Map<String, Object> calibrationParameters) throws CalculationException {
        if (calibrationParameters == null) {
            calibrationParameters = new HashMap<String, Object>();
        }
        Integer numberOfPathsParameter = (Integer)calibrationParameters.get("numberOfPaths");
        Integer seedParameter = (Integer)calibrationParameters.get("seed");
        Integer maxIterationsParameter = (Integer)calibrationParameters.get("maxIterations");
        Double parameterStepParameter = (Double)calibrationParameters.get("parameterStep");
        Double accuracyParameter = (Double)calibrationParameters.get("accuracy");
        BrownianMotion brownianMotionParameter = (BrownianMotion)calibrationParameters.get("brownianMotion");
        double[] initialParameters = this.getParameterAsDouble();
        double[] lowerBound = new double[initialParameters.length];
        double[] upperBound = new double[initialParameters.length];
        double[] parameterStep = new double[initialParameters.length];
        double[] zero = new double[calibrationProducts.length];
        Arrays.fill(lowerBound, Double.NEGATIVE_INFINITY);
        Arrays.fill(upperBound, Double.POSITIVE_INFINITY);
        Arrays.fill(parameterStep, parameterStepParameter != null ? parameterStepParameter : 1.0E-4);
        Arrays.fill(zero, 0.0);
        int numberOfThreads = 2;
        OptimizerFactory optimizerFactoryParameter = (OptimizerFactory)calibrationParameters.get("optimizerFactory");
        int numberOfPaths = numberOfPathsParameter != null ? numberOfPathsParameter : 2000;
        int seed = seedParameter != null ? seedParameter : 31415;
        int maxIterations = maxIterationsParameter != null ? maxIterationsParameter : 400;
        double accuracy = accuracyParameter != null ? accuracyParameter : 1.0E-7;
        final BrownianMotion brownianMotion = brownianMotionParameter != null ? brownianMotionParameter : new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), this.getNumberOfFactors(), numberOfPaths, seed);
        OptimizerFactory optimizerFactory = optimizerFactoryParameter != null ? optimizerFactoryParameter : new OptimizerFactoryLevenbergMarquardt(maxIterations, accuracy, 2);
        PriorityBlockingQueue<Runnable> queue = new PriorityBlockingQueue<Runnable>();
        final ThreadPoolExecutor executorForProductValuation = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * zero.length, 5L, TimeUnit.SECONDS, queue);
        Optimizer.ObjectiveFunction calibrationError = new Optimizer.ObjectiveFunction(){

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                int calibrationProductIndex;
                AbstractLIBORCovarianceModelParametric calibrationCovarianceModel = AbstractLIBORCovarianceModelParametric.this.getCloneWithModifiedParameters(parameters);
                LIBORMarketModel model = calibrationModel.getCloneWithModifiedCovarianceModel(calibrationCovarianceModel);
                EulerSchemeFromProcessModel process = new EulerSchemeFromProcessModel(model, brownianMotion);
                final LIBORMonteCarloSimulationFromLIBORModel liborMarketModelMonteCarloSimulation = new LIBORMonteCarloSimulationFromLIBORModel(process);
                ArrayList<FutureTaskWithPriority<RandomVariable>> valueFutures = new ArrayList<FutureTaskWithPriority<RandomVariable>>(calibrationProducts.length);
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    final int workerCalibrationProductIndex = calibrationProductIndex;
                    FutureTaskWithPriority<RandomVariable> valueFuture = new FutureTaskWithPriority<RandomVariable>(new Callable<RandomVariable>(){

                        @Override
                        public RandomVariable call() throws Exception {
                            try {
                                return calibrationProducts[workerCalibrationProductIndex].getProduct().getValue(0.0, liborMarketModelMonteCarloSimulation).sub(calibrationProducts[workerCalibrationProductIndex].getTargetValue()).mult(calibrationProducts[workerCalibrationProductIndex].getWeight());
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                    }, calibrationProducts[workerCalibrationProductIndex].getPriority());
                    if (executorForProductValuation != null) {
                        executorForProductValuation.execute(valueFuture);
                        valueFutures.add(calibrationProductIndex, valueFuture);
                        continue;
                    }
                    valueFuture.run();
                    valueFutures.add(calibrationProductIndex, valueFuture);
                }
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    try {
                        RandomVariable value = (RandomVariable)((Future)valueFutures.get(calibrationProductIndex)).get();
                        values[calibrationProductIndex] = value != null ? value.getAverage() : 0.0;
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new SolverException(e);
                    }
                }
            }
        };
        Optimizer optimizer = optimizerFactory.getOptimizer(calibrationError, initialParameters, lowerBound, upperBound, parameterStep, zero);
        try {
            AbstractLIBORCovarianceModelParametric calibrationCovarianceModel;
            optimizer.run();
            if (logger.isLoggable(Level.FINE)) {
                DecimalFormat formatterSci3 = new DecimalFormat("+0.###E0;-0.###E0");
                logger.fine("The solver required " + optimizer.getIterations() + " iterations. The best fit parameters are:");
                double[] bestParameters = optimizer.getBestFitParameters();
                Object logString = "Best parameters:";
                for (int i = 0; i < bestParameters.length; ++i) {
                    logString = (String)logString + "\tparameter[" + i + "]: " + bestParameters[i];
                }
                logger.fine((String)logString);
                double[] bestValues = new double[calibrationProducts.length];
                calibrationError.setValues(bestParameters, bestValues);
                Object logString2 = "Best values:";
                for (int i = 0; i < calibrationProducts.length; ++i) {
                    logString2 = (String)logString2 + "\n\t" + calibrationProducts[i].getName() + ": ";
                    logString2 = (String)logString2 + "value[" + i + "]: " + formatterSci3.format((Object)bestValues[i]);
                }
                logger.fine((String)logString2);
            }
            double[] bestParameters = optimizer.getBestFitParameters();
            AbstractLIBORCovarianceModelParametric abstractLIBORCovarianceModelParametric = calibrationCovarianceModel = this.getCloneWithModifiedParameters(bestParameters);
            return abstractLIBORCovarianceModelParametric;
        }
        catch (SolverException e) {
            throw new CalculationException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (executorForProductValuation != null) {
                executorForProductValuation.shutdown();
            }
        }
    }

    public String toString() {
        return "AbstractLIBORCovarianceModelParametric [getParameter()=" + Arrays.toString(this.getParameterAsDouble()) + "]";
    }

    static class FutureTaskWithPriority<T>
    extends FutureTask<T>
    implements Comparable<FutureTaskWithPriority<T>> {
        private final int priority;

        FutureTaskWithPriority(Callable<T> callable, int priority) {
            super(callable);
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(FutureTaskWithPriority<T> o) {
            return this.getPriority() < o.getPriority() ? -1 : (this.getPriority() == o.getPriority() ? 0 : 1);
        }
    }
}

