/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.interestrate.CalibrationProduct;
import net.finmath.montecarlo.interestrate.LIBORMonteCarloSimulationFromLIBORModel;
import net.finmath.montecarlo.interestrate.ShortRateModel;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractShortRateVolatilityModel;
import net.finmath.montecarlo.interestrate.models.covariance.ShortRateVolatilityModelCalibrateable;
import net.finmath.montecarlo.interestrate.models.covariance.ShortRateVolatilityModelParametric;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.optimizer.Optimizer;
import net.finmath.optimizer.OptimizerFactory;
import net.finmath.optimizer.OptimizerFactoryLevenbergMarquardt;
import net.finmath.optimizer.SolverException;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public abstract class AbstractShortRateVolatilityModelParametric
extends AbstractShortRateVolatilityModel
implements ShortRateVolatilityModelParametric,
ShortRateVolatilityModelCalibrateable {
    private static final long serialVersionUID = 7015719361182945464L;
    private static final Logger logger = Logger.getLogger("net.finmath");

    public AbstractShortRateVolatilityModelParametric(TimeDiscretization timeDiscretization) {
        super(timeDiscretization);
    }

    @Override
    public abstract RandomVariable[] getParameter();

    public abstract Object clone();

    @Override
    public double[] getParameterAsDouble() {
        RandomVariable[] parameters = this.getParameter();
        double[] parametersAsDouble = new double[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parametersAsDouble[i] = parameters[i].doubleValue();
        }
        return parametersAsDouble;
    }

    @Override
    public abstract AbstractShortRateVolatilityModelParametric getCloneWithModifiedParameters(double[] var1);

    @Override
    public abstract AbstractShortRateVolatilityModelParametric getCloneWithModifiedParameters(RandomVariable[] var1);

    @Override
    public AbstractShortRateVolatilityModelParametric getCloneCalibrated(ShortRateModel calibrationModel, CalibrationProduct[] calibrationProducts, Map<String, Object> calibrationParameters) throws CalculationException {
        return this.getCloneCalibratedLegazy(calibrationModel, calibrationProducts, calibrationParameters);
    }

    public AbstractShortRateVolatilityModelParametric getCloneCalibratedLegazy(final ShortRateModel calibrationModel, final CalibrationProduct[] calibrationProducts, Map<String, Object> calibrationParameters) throws CalculationException {
        if (calibrationParameters == null) {
            calibrationParameters = new HashMap<String, Object>();
        }
        Integer numberOfPathsParameter = (Integer)calibrationParameters.get("numberOfPaths");
        Integer seedParameter = (Integer)calibrationParameters.get("seed");
        Integer maxIterationsParameter = (Integer)calibrationParameters.get("maxIterations");
        Double parameterStepParameter = (Double)calibrationParameters.get("parameterStep");
        Double accuracyParameter = (Double)calibrationParameters.get("accuracy");
        BrownianMotion brownianMotionParameter = (BrownianMotion)calibrationParameters.get("brownianMotion");
        double[] initialParameters = this.getParameterAsDouble();
        double[] lowerBound = new double[initialParameters.length];
        double[] upperBound = new double[initialParameters.length];
        double[] parameterStep = new double[initialParameters.length];
        double[] zero = new double[calibrationProducts.length];
        Arrays.fill(lowerBound, Double.NEGATIVE_INFINITY);
        Arrays.fill(upperBound, Double.POSITIVE_INFINITY);
        Arrays.fill(parameterStep, parameterStepParameter != null ? parameterStepParameter : 1.0E-4);
        Arrays.fill(zero, 0.0);
        int numberOfThreads = 2;
        OptimizerFactory optimizerFactoryParameter = (OptimizerFactory)calibrationParameters.get("optimizerFactory");
        int numberOfPaths = numberOfPathsParameter != null ? numberOfPathsParameter : 2000;
        int seed = seedParameter != null ? seedParameter : 31415;
        int numberOfFactors = 2;
        int maxIterations = maxIterationsParameter != null ? maxIterationsParameter : 400;
        double accuracy = accuracyParameter != null ? accuracyParameter : 1.0E-7;
        final BrownianMotion brownianMotion = brownianMotionParameter != null ? brownianMotionParameter : new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), 2, numberOfPaths, seed);
        OptimizerFactory optimizerFactory = optimizerFactoryParameter != null ? optimizerFactoryParameter : new OptimizerFactoryLevenbergMarquardt(maxIterations, accuracy, 2);
        final ExecutorService executor = null;
        Optimizer.ObjectiveFunction calibrationError = new Optimizer.ObjectiveFunction(){

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                int calibrationProductIndex;
                AbstractShortRateVolatilityModelParametric calibrationVolatilityModel = AbstractShortRateVolatilityModelParametric.this.getCloneWithModifiedParameters(parameters);
                ShortRateModel model = calibrationModel.getCloneWithModifiedVolatilityModel(calibrationVolatilityModel);
                EulerSchemeFromProcessModel process = new EulerSchemeFromProcessModel(model, brownianMotion);
                final LIBORMonteCarloSimulationFromLIBORModel modelMonteCarloSimulation = new LIBORMonteCarloSimulationFromLIBORModel(process);
                ArrayList<Future<RandomVariable>> valueFutures = new ArrayList<Future<RandomVariable>>(calibrationProducts.length);
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    final int workerCalibrationProductIndex = calibrationProductIndex;
                    Callable<RandomVariable> worker = new Callable<RandomVariable>(){

                        @Override
                        public RandomVariable call() {
                            try {
                                return calibrationProducts[workerCalibrationProductIndex].getProduct().getValue(0.0, modelMonteCarloSimulation).sub(calibrationProducts[workerCalibrationProductIndex].getTargetValue()).mult(calibrationProducts[workerCalibrationProductIndex].getWeight());
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                    };
                    if (executor != null) {
                        Future<RandomVariable> valueFuture = executor.submit(worker);
                        valueFutures.add(calibrationProductIndex, valueFuture);
                        continue;
                    }
                    FutureTask<RandomVariable> valueFutureTask = new FutureTask<RandomVariable>(worker);
                    valueFutureTask.run();
                    valueFutures.add(calibrationProductIndex, valueFutureTask);
                }
                for (calibrationProductIndex = 0; calibrationProductIndex < calibrationProducts.length; ++calibrationProductIndex) {
                    try {
                        RandomVariable value = (RandomVariable)((Future)valueFutures.get(calibrationProductIndex)).get();
                        values[calibrationProductIndex] = value != null ? value.getAverage() : 0.0;
                        continue;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new SolverException(e);
                    }
                }
            }
        };
        Optimizer optimizer = optimizerFactory.getOptimizer(calibrationError, initialParameters, lowerBound, upperBound, parameterStep, zero);
        try {
            optimizer.run();
            if (logger.isLoggable(Level.FINE)) {
                DecimalFormat formatterSci3 = new DecimalFormat("+0.###E0;-0.###E0");
                logger.fine("The solver required " + optimizer.getIterations() + " iterations. The best fit parameters are:");
                double[] bestParameters = optimizer.getBestFitParameters();
                Object logString = "Best parameters:";
                for (int i = 0; i < bestParameters.length; ++i) {
                    logString = (String)logString + "\tparameter[" + i + "]: " + bestParameters[i];
                }
                logger.fine((String)logString);
                double[] bestValues = new double[calibrationProducts.length];
                calibrationError.setValues(bestParameters, bestValues);
                Object logString2 = "Best values:";
                for (int i = 0; i < calibrationProducts.length; ++i) {
                    logString2 = (String)logString2 + "\n\t" + calibrationProducts[i].getName() + ": ";
                    logString2 = (String)logString2 + "value[" + i + "]: " + formatterSci3.format((Object)bestValues[i]);
                }
                logger.fine((String)logString2);
            }
        }
        catch (SolverException e) {
            throw new CalculationException(e);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        double[] bestParameters = optimizer.getBestFitParameters();
        AbstractShortRateVolatilityModelParametric calibrationVolatilityModel = this.getCloneWithModifiedParameters(bestParameters);
        return calibrationVolatilityModel;
    }

    public String toString() {
        return "AbstractShortRateVolatilityModelParametric [getParameter()=" + Arrays.toString(this.getParameter()) + "]";
    }
}

