/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class ExponentialDecayLocalVolatilityModel
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = 4522227972747028512L;
    private final RandomVariableFactory randomVariableFactory;
    private final AbstractLIBORCovarianceModelParametric covarianceModel;
    private final RandomVariable decay;
    private boolean isCalibrateable = false;

    public ExponentialDecayLocalVolatilityModel(RandomVariableFactory randomVariableFactory, AbstractLIBORCovarianceModelParametric covarianceModel, RandomVariable decay, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.randomVariableFactory = randomVariableFactory;
        this.covarianceModel = covarianceModel;
        this.decay = decay;
        this.isCalibrateable = isCalibrateable;
    }

    public ExponentialDecayLocalVolatilityModel(RandomVariableFactory randomVariableFactory, AbstractLIBORCovarianceModelParametric covarianceModel, double decay, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.randomVariableFactory = randomVariableFactory;
        this.covarianceModel = covarianceModel;
        this.decay = randomVariableFactory != null ? randomVariableFactory.createRandomVariable(decay) : new Scalar(decay);
        this.isCalibrateable = isCalibrateable;
    }

    public ExponentialDecayLocalVolatilityModel(AbstractLIBORCovarianceModelParametric covarianceModel, double decay, boolean isCalibrateable) {
        this(null, covarianceModel, decay, isCalibrateable);
    }

    @Override
    public Object clone() {
        return new ExponentialDecayLocalVolatilityModel(this.randomVariableFactory, (AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.decay, this.isCalibrateable);
    }

    public AbstractLIBORCovarianceModelParametric getBaseCovarianceModel() {
        return this.covarianceModel;
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        RandomVariable[] covarianceParameters = this.covarianceModel.getParameter();
        if (covarianceParameters == null) {
            return new RandomVariable[]{this.decay};
        }
        RandomVariable[] jointParameters = new RandomVariable[covarianceParameters.length + 1];
        System.arraycopy(covarianceParameters, 0, jointParameters, 0, covarianceParameters.length);
        jointParameters[covarianceParameters.length] = this.decay;
        return jointParameters;
    }

    @Override
    public double[] getParameterAsDouble() {
        RandomVariable[] parameters = this.getParameter();
        double[] parametersAsDouble = new double[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parametersAsDouble[i] = parameters[i].doubleValue();
        }
        return parametersAsDouble;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return this;
        }
        if (!this.isCalibrateable) {
            return new ExponentialDecayLocalVolatilityModel(this.randomVariableFactory, this.covarianceModel.getCloneWithModifiedParameters(parameters), this.decay, this.isCalibrateable);
        }
        RandomVariable[] covarianceParameters = new RandomVariable[parameters.length - 1];
        System.arraycopy(parameters, 0, covarianceParameters, 0, covarianceParameters.length);
        AbstractLIBORCovarianceModelParametric newCovarianceModel = this.covarianceModel.getCloneWithModifiedParameters(covarianceParameters);
        RandomVariable newDisplacement = parameters[covarianceParameters.length];
        return new ExponentialDecayLocalVolatilityModel(this.randomVariableFactory, newCovarianceModel, newDisplacement, this.isCalibrateable);
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return this.getCloneWithModifiedParameters(Scalar.arrayOf(parameters));
    }

    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double fixing = this.getLiborPeriodDiscretization().getTime(component);
        double timeToMaturity = fixing - time;
        for (int factorIndex = 0; factorIndex < factorLoading.length; ++factorIndex) {
            factorLoading[factorIndex] = factorLoading[factorIndex].mult(this.decay.mult(-timeToMaturity).exp());
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable getDisplacement() {
        return this.decay;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        RandomVariable newDecay = this.decay;
        boolean isCalibrateable = this.isCalibrateable;
        AbstractLIBORCovarianceModelParametric covarianceModel = this.covarianceModel;
        RandomVariableFactory newRandomVariableFactory = this.randomVariableFactory;
        if (dataModified != null) {
            if (dataModified.containsKey("randomVariableFactory")) {
                newRandomVariableFactory = (RandomVariableFactory)dataModified.get("randomVariableFactory");
                newDecay = newRandomVariableFactory.createRandomVariable(newDecay.doubleValue());
            }
            if (!dataModified.containsKey("covarianceModel")) {
                covarianceModel = covarianceModel.getCloneWithModifiedData(dataModified);
            }
            covarianceModel = (AbstractLIBORCovarianceModelParametric)dataModified.getOrDefault("covarianceModel", covarianceModel);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
            newDecay = dataModified.getOrDefault("decay", newDecay) instanceof RandomVariable ? (RandomVariable)dataModified.getOrDefault("decay", newDecay) : (newRandomVariableFactory == null ? new Scalar((Double)dataModified.get("decay")) : newRandomVariableFactory.createRandomVariable((Double)dataModified.get("decay")));
        }
        ExponentialDecayLocalVolatilityModel newModel = new ExponentialDecayLocalVolatilityModel(newRandomVariableFactory, covarianceModel, newDecay, isCalibrateable);
        return newModel;
    }
}

