/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class LIBORCovarianceModelBH
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = 2094266336585778694L;
    private double[] parameter = new double[5];

    public LIBORCovarianceModelBH(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors, double[] parameter) {
        super(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
        this.parameter = parameter;
    }

    public LIBORCovarianceModelBH(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfFactors) {
        super(timeDiscretization, liborPeriodDiscretization, numberOfFactors);
        this.parameter[0] = 0.469;
        this.parameter[1] = 0.0452;
        this.parameter[2] = 0.35;
        this.parameter[3] = 0.01;
        this.parameter[4] = -0.8918;
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelBH model = new LIBORCovarianceModelBH(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), this.getParameterAsDouble());
        return model;
    }

    @Override
    public double[] getParameterAsDouble() {
        return this.parameter;
    }

    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        double timeToMaturity = this.getLiborPeriodDiscretization().getTime(component) - this.getTimeDiscretization().getTime(timeIndex);
        double s1 = timeToMaturity <= 0.0 ? 0.0 : this.parameter[0] * Math.exp(-this.parameter[1] * timeToMaturity);
        double s2 = timeToMaturity <= 0.0 ? 0.0 : this.parameter[2] * Math.exp(-this.parameter[3] * timeToMaturity);
        double rho = this.parameter[4];
        RandomVariable[] factorLoading = new RandomVariable[]{new RandomVariableFromDoubleArray(this.getTimeDiscretization().getTime(timeIndex), Math.sqrt(1.0 - rho * rho) * s1), new RandomVariableFromDoubleArray(this.getTimeDiscretization().getTime(timeIndex), rho * s1 + s2)};
        return factorLoading;
    }

    @Override
    public RandomVariableFromDoubleArray getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        LIBORCovarianceModelBH model = new LIBORCovarianceModelBH(this.getTimeDiscretization(), this.getLiborPeriodDiscretization(), this.getNumberOfFactors(), parameters);
        return model;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        TimeDiscretization timeDiscretization = this.getTimeDiscretization();
        TimeDiscretization liborPeriodDiscretization = this.getLiborPeriodDiscretization();
        int numberOfFactors = this.getNumberOfFactors();
        double[] parameter = this.parameter;
        if (dataModified != null) {
            timeDiscretization = (TimeDiscretization)dataModified.getOrDefault("timeDiscretization", timeDiscretization);
            liborPeriodDiscretization = (TimeDiscretization)dataModified.getOrDefault("liborPeriodDiscretization", liborPeriodDiscretization);
            numberOfFactors = (Integer)dataModified.getOrDefault("numberOfFactors", numberOfFactors);
            parameter = (double[])dataModified.getOrDefault("parameter", parameter);
        }
        LIBORCovarianceModelBH newModel = new LIBORCovarianceModelBH(timeDiscretization, liborPeriodDiscretization, numberOfFactors, parameter);
        return newModel;
    }
}

