/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.time.LocalDateTime;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class LIBORCovarianceModelStochasticHestonVolatility
extends AbstractLIBORCovarianceModelParametric {
    private static final long serialVersionUID = -1438451123632424212L;
    private AbstractLIBORCovarianceModelParametric covarianceModel;
    private final BrownianMotion brownianMotion;
    private RandomVariable kappa;
    private RandomVariable theta;
    private RandomVariable xi;
    private boolean isCalibrateable = false;
    private transient MonteCarloProcess stochasticVolatilityScalings = null;

    public LIBORCovarianceModelStochasticHestonVolatility(AbstractLIBORCovarianceModelParametric covarianceModel, BrownianMotion brownianMotion, RandomVariable kappa, RandomVariable theta, RandomVariable xi, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.brownianMotion = brownianMotion;
        this.kappa = kappa;
        this.theta = theta;
        this.xi = xi;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORCovarianceModelStochasticHestonVolatility(AbstractLIBORCovarianceModelParametric covarianceModel, BrownianMotion brownianMotion, double kappa, double theta, double xi, boolean isCalibrateable) {
        super(covarianceModel.getTimeDiscretization(), covarianceModel.getLiborPeriodDiscretization(), covarianceModel.getNumberOfFactors());
        this.covarianceModel = covarianceModel;
        this.brownianMotion = brownianMotion;
        this.kappa = new Scalar(kappa);
        this.theta = new Scalar(theta);
        this.xi = new Scalar(xi);
        this.isCalibrateable = isCalibrateable;
    }

    @Override
    public RandomVariable[] getParameter() {
        if (!this.isCalibrateable) {
            return this.covarianceModel.getParameter();
        }
        RandomVariable[] covarianceParameters = this.covarianceModel.getParameter();
        if (covarianceParameters == null) {
            return new RandomVariable[]{this.theta, this.kappa, this.xi};
        }
        RandomVariable[] jointParameters = new RandomVariable[covarianceParameters.length + 3];
        System.arraycopy(covarianceParameters, 0, jointParameters, 0, covarianceParameters.length);
        jointParameters[covarianceParameters.length + 0] = this.kappa;
        jointParameters[covarianceParameters.length + 1] = this.theta;
        jointParameters[covarianceParameters.length + 2] = this.xi;
        return jointParameters;
    }

    private void setParameter(RandomVariable[] parameter) {
        if (parameter == null || parameter.length == 0) {
            return;
        }
        if (!this.isCalibrateable) {
            this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(parameter);
            return;
        }
        RandomVariable[] covarianceParameters = new RandomVariable[parameter.length - 3];
        System.arraycopy(parameter, 0, covarianceParameters, 0, covarianceParameters.length);
        this.covarianceModel = this.covarianceModel.getCloneWithModifiedParameters(covarianceParameters);
        this.kappa = parameter[covarianceParameters.length + 0];
        this.theta = parameter[covarianceParameters.length + 1];
        this.xi = parameter[covarianceParameters.length + 2];
        this.stochasticVolatilityScalings = null;
    }

    @Override
    public Object clone() {
        LIBORCovarianceModelStochasticHestonVolatility newModel = new LIBORCovarianceModelStochasticHestonVolatility((AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone(), this.brownianMotion, this.kappa, this.theta, this.xi, this.isCalibrateable);
        return newModel;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(RandomVariable[] parameters) {
        LIBORCovarianceModelStochasticHestonVolatility model = (LIBORCovarianceModelStochasticHestonVolatility)this.clone();
        model.setParameter(parameters);
        return model;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        return this.getCloneWithModifiedParameters(Scalar.arrayOf(parameters));
    }

    @Override
    public double[] getParameterAsDouble() {
        RandomVariable[] parameters = this.getParameter();
        double[] parametersAsDouble = new double[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parametersAsDouble[i] = parameters[i].doubleValue();
        }
        return parametersAsDouble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable[] getFactorLoading(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        LIBORCovarianceModelStochasticHestonVolatility lIBORCovarianceModelStochasticHestonVolatility = this;
        synchronized (lIBORCovarianceModelStochasticHestonVolatility) {
            if (this.stochasticVolatilityScalings == null) {
                ProcessModel model = new ProcessModel(){

                    @Override
                    public LocalDateTime getReferenceDate() {
                        throw new UnsupportedOperationException("This model does not provide a reference date. Reference dates will be mandatory in a future version.");
                    }

                    @Override
                    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int getNumberOfFactors() {
                        return 1;
                    }

                    @Override
                    public int getNumberOfComponents() {
                        return 1;
                    }

                    @Override
                    public RandomVariable[] getInitialState(MonteCarloProcess process) {
                        return new RandomVariable[]{LIBORCovarianceModelStochasticHestonVolatility.this.brownianMotion.getRandomVariableForConstant(1.0)};
                    }

                    @Override
                    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
                        return new RandomVariable[]{realizationAtTimeIndex[0].floor(0.0).sqrt().mult(LIBORCovarianceModelStochasticHestonVolatility.this.xi)};
                    }

                    @Override
                    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
                        return new RandomVariable[]{realizationAtTimeIndex[0].sub(LIBORCovarianceModelStochasticHestonVolatility.this.theta).mult(LIBORCovarianceModelStochasticHestonVolatility.this.kappa.mult(-1.0))};
                    }

                    @Override
                    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
                        return randomVariable;
                    }

                    @Override
                    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
                        return randomVariable;
                    }

                    @Override
                    public RandomVariable getRandomVariableForConstant(double value) {
                        throw new UnsupportedOperationException("Method not implemented");
                    }

                    @Override
                    public ProcessModel getCloneWithModifiedData(Map<String, Object> dataModified) {
                        throw new UnsupportedOperationException("Method not implemented");
                    }
                };
                this.stochasticVolatilityScalings = new EulerSchemeFromProcessModel(model, this.brownianMotion);
            }
        }
        RandomVariable stochasticVolatilityScaling = null;
        try {
            stochasticVolatilityScaling = this.stochasticVolatilityScalings.getProcessValue(timeIndex, 0);
        }
        catch (CalculationException model) {
            // empty catch block
        }
        RandomVariable[] factorLoading = null;
        if (stochasticVolatilityScaling != null) {
            factorLoading = this.covarianceModel.getFactorLoading(timeIndex, component, realizationAtTimeIndex);
            for (int i = 0; i < factorLoading.length; ++i) {
                factorLoading[i] = factorLoading[i].mult(stochasticVolatilityScaling.floor(0.0).sqrt());
            }
        }
        return factorLoading;
    }

    @Override
    public RandomVariable getFactorLoadingPseudoInverse(int timeIndex, int component, int factor, RandomVariable[] realizationAtTimeIndex) {
        return null;
    }

    @Override
    public AbstractLIBORCovarianceModelParametric getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        AbstractLIBORCovarianceModelParametric covarianceModel = this.covarianceModel;
        BrownianMotion brownianMotion = this.brownianMotion;
        RandomVariable kappa = this.kappa;
        RandomVariable theta = this.theta;
        RandomVariable xi = this.xi;
        boolean isCalibrateable = this.isCalibrateable;
        RandomVariableFactory randomVariableFactory = null;
        if (dataModified != null) {
            if (dataModified.containsKey("randomVariableFactory")) {
                randomVariableFactory = (RandomVariableFactory)dataModified.get("randomVariableFactory");
                kappa = randomVariableFactory.createRandomVariable(kappa.doubleValue());
                theta = randomVariableFactory.createRandomVariable(theta.doubleValue());
                xi = randomVariableFactory.createRandomVariable(xi.doubleValue());
            }
            if (!dataModified.containsKey("covarianceModel")) {
                covarianceModel = covarianceModel.getCloneWithModifiedData(dataModified);
            }
            covarianceModel = (AbstractLIBORCovarianceModelParametric)dataModified.getOrDefault("covarianceModel", covarianceModel);
            isCalibrateable = (Boolean)dataModified.getOrDefault("isCalibrateable", isCalibrateable);
            brownianMotion = (BrownianMotion)dataModified.getOrDefault("brownianMotion", brownianMotion);
            kappa = dataModified.getOrDefault("kappa", kappa) instanceof RandomVariable ? (RandomVariable)dataModified.getOrDefault("kappa", kappa) : (randomVariableFactory == null ? new Scalar((Double)dataModified.get("kappa")) : randomVariableFactory.createRandomVariable((Double)dataModified.get("kappa")));
            theta = dataModified.getOrDefault("theta", theta) instanceof RandomVariable ? (RandomVariable)dataModified.getOrDefault("rho", theta) : (randomVariableFactory == null ? new Scalar((Double)dataModified.get("theta")) : randomVariableFactory.createRandomVariable((Double)dataModified.get("theta")));
            xi = dataModified.getOrDefault("xi", xi) instanceof RandomVariable ? (RandomVariable)dataModified.getOrDefault("xi", xi) : (randomVariableFactory == null ? new Scalar((Double)dataModified.get("xi")) : randomVariableFactory.createRandomVariable((Double)dataModified.get("xi")));
        }
        LIBORCovarianceModelStochasticHestonVolatility newModel = new LIBORCovarianceModelStochasticHestonVolatility(covarianceModel, brownianMotion, kappa, theta, xi, isCalibrateable);
        return newModel;
    }
}

