/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class LIBORVolatilityModelTimeHomogenousPiecewiseConstant
extends LIBORVolatilityModel {
    private static final long serialVersionUID = -1942151065049237807L;
    private final RandomVariableFactory randomVariableFactory;
    private final TimeDiscretization timeToMaturityDiscretization;
    private final RandomVariable[] volatility;

    public LIBORVolatilityModelTimeHomogenousPiecewiseConstant(RandomVariableFactory randomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization timeToMaturityDiscretization, RandomVariable[] volatility) {
        super(timeDiscretization, liborPeriodDiscretization);
        if (timeToMaturityDiscretization.getTime(0) != 0.0) {
            throw new IllegalArgumentException("timeToMaturityDiscretization should start with 0 as first time point.");
        }
        if (timeToMaturityDiscretization.getNumberOfTimes() != volatility.length) {
            throw new IllegalArgumentException("volatility.length should equal timeToMaturityDiscretization.getNumberOfTimes() .");
        }
        this.randomVariableFactory = randomVariableFactory;
        this.timeToMaturityDiscretization = timeToMaturityDiscretization;
        this.volatility = volatility;
    }

    public LIBORVolatilityModelTimeHomogenousPiecewiseConstant(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization timeToMaturityDiscretization, RandomVariable[] volatility) {
        this(null, timeDiscretization, liborPeriodDiscretization, timeToMaturityDiscretization, volatility);
    }

    public LIBORVolatilityModelTimeHomogenousPiecewiseConstant(RandomVariableFactory randomVariableFactory, TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization timeToMaturityDiscretization, double[] volatility) {
        super(timeDiscretization, liborPeriodDiscretization);
        if (timeToMaturityDiscretization.getTime(0) != 0.0) {
            throw new IllegalArgumentException("timeToMaturityDiscretization should start with 0 as first time point.");
        }
        if (timeToMaturityDiscretization.getNumberOfTimes() != volatility.length) {
            throw new IllegalArgumentException("volatility.length should equal timeToMaturityDiscretization.getNumberOfTimes() .");
        }
        this.randomVariableFactory = randomVariableFactory;
        this.timeToMaturityDiscretization = timeToMaturityDiscretization;
        this.volatility = randomVariableFactory.createRandomVariableArray(volatility);
    }

    public LIBORVolatilityModelTimeHomogenousPiecewiseConstant(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, TimeDiscretization timeToMaturityDiscretization, double[] volatility) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), timeDiscretization, liborPeriodDiscretization, timeToMaturityDiscretization, volatility);
    }

    @Override
    public RandomVariable[] getParameter() {
        return this.volatility;
    }

    @Override
    public LIBORVolatilityModelTimeHomogenousPiecewiseConstant getCloneWithModifiedParameter(RandomVariable[] parameter) {
        return new LIBORVolatilityModelTimeHomogenousPiecewiseConstant(this.randomVariableFactory, super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.timeToMaturityDiscretization, parameter);
    }

    @Override
    public RandomVariable getVolatility(int timeIndex, int liborIndex) {
        RandomVariable volatilityInstanteaneous;
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double timeToMaturity = maturity - time;
        if (timeToMaturity <= 0.0) {
            volatilityInstanteaneous = new Scalar(0.0);
        } else {
            int timeIndexTimeToMaturity = this.timeToMaturityDiscretization.getTimeIndex(timeToMaturity);
            if (timeIndexTimeToMaturity < 0) {
                timeIndexTimeToMaturity = -timeIndexTimeToMaturity - 1 - 1;
            }
            if (timeIndexTimeToMaturity < 0) {
                timeIndexTimeToMaturity = 0;
            }
            if (timeIndexTimeToMaturity >= this.timeToMaturityDiscretization.getNumberOfTimes()) {
                --timeIndexTimeToMaturity;
            }
            volatilityInstanteaneous = this.volatility[timeIndexTimeToMaturity];
        }
        return volatilityInstanteaneous;
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelTimeHomogenousPiecewiseConstant(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.timeToMaturityDiscretization, (RandomVariable[])this.volatility.clone());
    }

    @Override
    public LIBORVolatilityModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        return null;
    }
}

