/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.models.covariance.AbstractLIBORCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.TermStructureCovarianceModelParametric;
import net.finmath.montecarlo.interestrate.models.covariance.TermStructureTenorTimeScaling;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class TermStructCovarianceModelFromLIBORCovarianceModelParametric
extends TermStructureCovarianceModelParametric {
    private final TermStructureTenorTimeScaling tenorTimeScalingModel;
    private final AbstractLIBORCovarianceModelParametric covarianceModel;

    public TermStructCovarianceModelFromLIBORCovarianceModelParametric(TermStructureTenorTimeScaling tenorTimeScalingModel, AbstractLIBORCovarianceModelParametric covarianceModel) {
        this.tenorTimeScalingModel = tenorTimeScalingModel;
        this.covarianceModel = covarianceModel;
    }

    @Override
    public double getScaledTenorTime(double periodStart, double periodEnd) {
        if (this.tenorTimeScalingModel == null) {
            return periodEnd - periodStart;
        }
        return this.tenorTimeScalingModel.getScaledTenorTime(periodStart, periodEnd);
    }

    @Override
    public RandomVariable[] getFactorLoading(double time, double periodStart, double periodEnd, TimeDiscretization periodDiscretization, RandomVariable[] realizationAtTimeIndex, TermStructureModel model) {
        int componentIndex2;
        int componentIndex;
        TimeDiscretization liborPeriodDiscretization = this.covarianceModel.getLiborPeriodDiscretization();
        int periodStartIndex = liborPeriodDiscretization.getTimeIndex(periodStart);
        int periodEndIndex = liborPeriodDiscretization.getTimeIndex(periodEnd);
        RandomVariable[] factorLoadings = this.covarianceModel.getFactorLoading(time, periodStartIndex, (RandomVariable[])null);
        if (periodEndIndex > periodStartIndex + 1) {
            int factorIndex;
            for (factorIndex = 0; factorIndex < factorLoadings.length; ++factorIndex) {
                factorLoadings[factorIndex] = factorLoadings[factorIndex].mult(liborPeriodDiscretization.getTimeStep(periodStartIndex));
            }
            for (int periodIndex = periodStartIndex + 1; periodIndex < periodEndIndex; ++periodIndex) {
                RandomVariable[] factorLoadingsForPeriod = this.covarianceModel.getFactorLoading(time, periodStartIndex, (RandomVariable[])null);
                double periodLength = liborPeriodDiscretization.getTimeStep(periodIndex);
                for (int factorIndex2 = 0; factorIndex2 < factorLoadings.length; ++factorIndex2) {
                    factorLoadings[factorIndex2] = factorLoadings[factorIndex2].addProduct(factorLoadingsForPeriod[factorIndex2], periodLength);
                }
            }
            for (factorIndex = 0; factorIndex < factorLoadings.length; ++factorIndex) {
                factorLoadings[factorIndex] = factorLoadings[factorIndex].div(periodEnd - periodStart);
            }
        }
        if ((componentIndex = periodDiscretization.getTimeIndex(periodStart)) < 0) {
            componentIndex = -componentIndex - 1 - 1;
        }
        if ((componentIndex2 = periodDiscretization.getTimeIndex(periodEnd)) < 0) {
            componentIndex2 = -componentIndex2 - 1;
        }
        if (componentIndex != componentIndex2 - 1) {
            throw new IllegalArgumentException();
        }
        return factorLoadings;
    }

    @Override
    public int getNumberOfFactors() {
        return this.covarianceModel.getNumberOfFactors();
    }

    @Override
    public double[] getParameter() {
        if (this.tenorTimeScalingModel == null) {
            return this.covarianceModel.getParameterAsDouble();
        }
        double[] tenorTimeScalingParameter = this.tenorTimeScalingModel.getParameter();
        double[] covarianceParameter = this.covarianceModel.getParameterAsDouble();
        double[] parameter = new double[tenorTimeScalingParameter.length + covarianceParameter.length];
        System.arraycopy(tenorTimeScalingParameter, 0, parameter, 0, tenorTimeScalingParameter.length);
        System.arraycopy(covarianceParameter, 0, parameter, tenorTimeScalingParameter.length, covarianceParameter.length);
        return parameter;
    }

    @Override
    public TermStructureCovarianceModelParametric getCloneWithModifiedParameters(double[] parameters) {
        if (this.tenorTimeScalingModel == null) {
            return new TermStructCovarianceModelFromLIBORCovarianceModelParametric(null, this.covarianceModel.getCloneWithModifiedParameters(parameters));
        }
        double[] tenorTimeScalingParameter = this.tenorTimeScalingModel.getParameter();
        double[] covarianceParameter = this.covarianceModel.getParameterAsDouble();
        System.arraycopy(parameters, 0, tenorTimeScalingParameter, 0, tenorTimeScalingParameter.length);
        System.arraycopy(parameters, tenorTimeScalingParameter.length, covarianceParameter, 0, covarianceParameter.length);
        return new TermStructCovarianceModelFromLIBORCovarianceModelParametric(this.tenorTimeScalingModel.getCloneWithModifiedParameters(tenorTimeScalingParameter), this.covarianceModel.getCloneWithModifiedParameters(covarianceParameter));
    }

    @Override
    public TermStructureCovarianceModelParametric clone() {
        return new TermStructCovarianceModelFromLIBORCovarianceModelParametric(this.tenorTimeScalingModel.clone(), (AbstractLIBORCovarianceModelParametric)this.covarianceModel.clone());
    }
}

