/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.models.covariance;

import net.finmath.montecarlo.interestrate.models.covariance.TermStructureTenorTimeScaling;
import net.finmath.time.TimeDiscretization;

public class TermStructureTenorTimeScalingPicewiseConstant
implements TermStructureTenorTimeScaling {
    private final TimeDiscretization timeDiscretization;
    private final double[] timesIntegrated;
    private final double floor = -0.9;
    private final double cap = 9.0;
    private final double parameterScaling = 100.0;

    public TermStructureTenorTimeScalingPicewiseConstant(TimeDiscretization timeDiscretization, double[] parameters) {
        this.timeDiscretization = timeDiscretization;
        this.timesIntegrated = new double[timeDiscretization.getNumberOfTimes()];
        for (int timeIntervalIndex = 0; timeIntervalIndex < timeDiscretization.getNumberOfTimeSteps(); ++timeIntervalIndex) {
            this.timesIntegrated[timeIntervalIndex + 1] = this.timesIntegrated[timeIntervalIndex] + (1.0 + Math.min(Math.max(100.0 * parameters[timeIntervalIndex], -0.9), 9.0)) * timeDiscretization.getTimeStep(timeIntervalIndex);
        }
    }

    @Override
    public double getScaledTenorTime(double periodStart, double periodEnd) {
        double timeIntegratedEnd;
        double timeIntegratedStart;
        int timeStartIndex = this.timeDiscretization.getTimeIndex(periodStart);
        if (timeStartIndex >= 0) {
            timeIntegratedStart = this.timesIntegrated[timeStartIndex];
        } else {
            int timeStartIndexLo = -timeStartIndex - 2;
            timeIntegratedStart = (this.timesIntegrated[timeStartIndexLo + 1] - this.timesIntegrated[timeStartIndexLo]) / this.timeDiscretization.getTimeStep(timeStartIndexLo) * (this.timeDiscretization.getTime(timeStartIndexLo + 1) - periodStart);
        }
        int timeEndIndex = this.timeDiscretization.getTimeIndex(periodEnd);
        if (timeEndIndex >= 0) {
            timeIntegratedEnd = this.timesIntegrated[timeEndIndex];
        } else {
            int timeEndIndexLo = -timeEndIndex - 2;
            timeIntegratedEnd = (this.timesIntegrated[timeEndIndexLo + 1] - this.timesIntegrated[timeEndIndexLo]) / this.timeDiscretization.getTimeStep(timeEndIndexLo) * (periodEnd - this.timeDiscretization.getTime(timeEndIndexLo));
        }
        double timeScaled = timeIntegratedEnd - timeIntegratedStart;
        return timeScaled;
    }

    @Override
    public TermStructureTenorTimeScaling getCloneWithModifiedParameters(double[] parameters) {
        return new TermStructureTenorTimeScalingPicewiseConstant(this.timeDiscretization, parameters);
    }

    @Override
    public double[] getParameter() {
        double[] parameter = new double[this.timeDiscretization.getNumberOfTimeSteps()];
        for (int timeIntervalIndex = 0; timeIntervalIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIntervalIndex) {
            parameter[timeIntervalIndex] = ((this.timesIntegrated[timeIntervalIndex + 1] - this.timesIntegrated[timeIntervalIndex]) / this.timeDiscretization.getTimeStep(timeIntervalIndex) - 1.0) / 100.0;
        }
        return parameter;
    }

    @Override
    public TermStructureTenorTimeScaling clone() {
        return this;
    }
}

