/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractTermStructureMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class DigitalCaplet
extends AbstractTermStructureMonteCarloProduct {
    private final double optionMaturity;
    private final double periodStart;
    private final double periodEnd;
    private final double strike;

    public DigitalCaplet(double optionMaturity, double periodStart, double periodEnd, double strike) {
        this.optionMaturity = optionMaturity;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.strike = strike;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        double paymentDate = this.periodEnd;
        double periodLength = this.periodEnd - this.periodStart;
        RandomVariable libor = model.getForwardRate(this.optionMaturity, this.periodStart, this.periodEnd);
        RandomVariable trigger = libor.sub(this.strike);
        RandomVariable values = trigger.choose(new Scalar(periodLength), new Scalar(0.0));
        RandomVariable numeraire = model.getNumeraire(paymentDate);
        RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(paymentDate);
        values = values.div(numeraire).mult(monteCarloProbabilities);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }

    public double getOptionMaturity() {
        return this.optionMaturity;
    }

    public double getPeriodStart() {
        return this.periodStart;
    }

    public double getPeriodEnd() {
        return this.periodEnd;
    }

    public double getStrike() {
        return this.strike;
    }
}

