/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractTermStructureMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class FlexiCap
extends AbstractTermStructureMonteCarloProduct {
    private final double[] fixingDates;
    private final double[] paymentDates;
    private final double[] strikes;
    private final int maximumNumberOfExercises;

    public FlexiCap(double[] fixingDates, double[] paymentDates, double[] strikes, int maximumNumberOfExercises) {
        this.fixingDates = fixingDates;
        this.paymentDates = paymentDates;
        this.strikes = strikes;
        this.maximumNumberOfExercises = maximumNumberOfExercises;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = new RandomVariableFromDoubleArray(0.0);
        RandomVariable numberOfExcercises = new RandomVariableFromDoubleArray((double)this.maximumNumberOfExercises - 0.5);
        for (int period = 0; period < this.fixingDates.length; ++period) {
            double fixingDate = this.fixingDates[period];
            double paymentDate = this.paymentDates[period];
            if (evaluationTime > paymentDate) continue;
            double strike = this.strikes[period];
            double periodLength = paymentDate - fixingDate;
            RandomVariable libor = model.getForwardRate(fixingDate, fixingDate, paymentDate);
            RandomVariable numeraire = model.getNumeraire(paymentDate);
            RandomVariable monteCarloProbabilities = model.getMonteCarloWeights(model.getTimeIndex(paymentDate));
            RandomVariable payoff = libor.sub(strike).mult(periodLength);
            RandomVariable indicator = payoff.choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0));
            indicator = numberOfExcercises.choose(indicator, new Scalar(0.0));
            payoff = payoff.div(numeraire).mult(monteCarloProbabilities);
            values = values.addProduct(indicator, payoff);
            numberOfExcercises = numberOfExcercises.sub(indicator);
        }
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvaluationTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvaluationTime).div(monteCarloProbabilitiesAtEvaluationTime);
        return values;
    }

    public double[] getStrikes() {
        return this.strikes;
    }
}

