/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractTermStructureMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class LIBORBond
extends AbstractTermStructureMonteCarloProduct {
    private final double maturity;

    public LIBORBond(double maturity) {
        this.maturity = maturity;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        if (evaluationTime > this.maturity) {
            return new Scalar(0.0);
        }
        return model.getForwardRate(evaluationTime, evaluationTime, this.maturity).mult(this.maturity - evaluationTime).add(1.0).invert();
    }

    public double getMaturity() {
        return this.maturity;
    }

    @Override
    public String toString() {
        return super.toString() + "\nmaturity: " + this.maturity;
    }
}

