/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.AbstractMonteCarloProduct;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.products.SwaptionSingleCurveAnalyticApproximation;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class SwaprateCovarianceAnalyticApproximation
extends AbstractMonteCarloProduct {
    private final double[] swapTenor1;
    private final double[] swapTenor2;

    public SwaprateCovarianceAnalyticApproximation(double[] swapTenor1, double[] swapTenor2) {
        this.swapTenor1 = swapTenor1;
        this.swapTenor2 = swapTenor2;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, MonteCarloSimulationModel model) throws CalculationException {
        if (!(model instanceof LIBORModelMonteCarloSimulationModel)) {
            throw new IllegalArgumentException("This product requires a simulation of type LIBORModelMonteCarloSimulationModel where the underlying model is of type LIBORMarketModel.");
        }
        TermStructureModel modelBase = ((LIBORModelMonteCarloSimulationModel)model).getModel();
        if (modelBase instanceof LIBORMarketModel) {
            return this.getValues(evaluationTime, model.getTimeDiscretization(), (LIBORMarketModel)modelBase);
        }
        throw new IllegalArgumentException("This product requires a simulation where the underlying model is of type LIBORMarketModel.");
    }

    public RandomVariable getValues(double evaluationTime, TimeDiscretization timeDiscretization, LIBORMarketModel model) {
        int swapStartIndex1 = model.getLiborPeriodIndex(this.swapTenor1[0]);
        int swapEndIndex1 = model.getLiborPeriodIndex(this.swapTenor1[this.swapTenor1.length - 1]);
        int swapStartIndex2 = model.getLiborPeriodIndex(this.swapTenor2[0]);
        int swapEndIndex2 = model.getLiborPeriodIndex(this.swapTenor2[this.swapTenor2.length - 1]);
        int optionMaturityIndex = model.getCovarianceModel().getTimeDiscretization().getTimeIndex(Math.min(this.swapTenor1[0], this.swapTenor2[0]));
        double[] swapCovarianceWeights1 = SwaptionSingleCurveAnalyticApproximation.getLogSwaprateDerivative(model.getLiborPeriodDiscretization(), model.getForwardRateCurve(), this.swapTenor1).get("values");
        double[] swapCovarianceWeights2 = SwaptionSingleCurveAnalyticApproximation.getLogSwaprateDerivative(model.getLiborPeriodDiscretization(), model.getForwardRateCurve(), this.swapTenor2).get("values");
        double[][] integratedLIBORCovariance = model.getIntegratedLIBORCovariance(timeDiscretization)[optionMaturityIndex];
        double integratedSwapRateCovariance = 0.0;
        for (int componentIndex1 = swapStartIndex1; componentIndex1 < swapEndIndex1; ++componentIndex1) {
            for (int componentIndex2 = swapStartIndex2; componentIndex2 < swapEndIndex2; ++componentIndex2) {
                integratedSwapRateCovariance += swapCovarianceWeights1[componentIndex1 - swapStartIndex1] * swapCovarianceWeights2[componentIndex2 - swapStartIndex2] * integratedLIBORCovariance[componentIndex1][componentIndex2];
            }
        }
        return new RandomVariableFromDoubleArray(evaluationTime, integratedSwapRateCovariance);
    }
}

